<?php

namespace PragmaRX\Google2FAQRCode\Tests;

class Constants
{
    const SECRET = 'ADUMJO5634NPDEKW';

    const QRCODEPHPABOVE72_V1 = 'data:image/png;base64,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';

    const QRCODEPHPBELOW72_V1 = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAMgAAADICAIAAAAiOjnJAAAFjklEQVR4nO3dwY6dOhBF0ZdW/v+TW28WMbhWV1Fn25DsNYzAkOSIW7JN8ev7+/s/Ke3r9A3o72SwhDBYQhgsIQyWEAZLCIMlhMESwmAJYbCEMFhCGCwhDJYQBksIgyWEwRLCYAnx+95pX1/5RE72sq7upzLm9dzJ8ZN7qFyrMuZz/l98YglhsIQwWELcrLGuiBqiWyusah269uoeU3EdZ3Jd4v+lMcLwfOkjgyWEwRIiUGNdVX6bK7/9q5opVUt1a7vuPVTqpMp1u8dMzs2+E+8TSwiDJYTBEiJcY6VUappU7dIdZzK/1a2Tun/f5/CJJYTBEsJgCfHQGitVT3Trs8pcVGp9s4vY78XxiSWEwRLCYAkRrrFSv/eT+ZvJuttkXio1p5Waw7vaX4f5xBLCYAlhsIQI1Fj0/E33Hrp7uVJ1zM77IfbaZ53PhP5KBksIgyXEzRqLnheZzPdUxunukUrNG+38dzvLJ5YQBksIgyXEgf5Yk/pmsme88udEP63KdbtOzY3V+cQSwmAJYbCECPfHIvpznuqrmeqVMJnTmvS56MrWWz6xhDBYQhgsIX6FuyIN9gntn2vJ3ltlnJXJfBgxl+Y8lh7KYAlhsIS4WWN1a5EVYn/3zj3jp+4z1XOV+xaQTywhDJYQBkuIcI21Mvnt795D6rs3k2Mqx+/8vmFq/MadbLiG/kEGSwiDJURgrXBnXTK5t5VT9VzFznm4ynXrfGIJYbCEMFhCHHivcDUO/Y4e0V+0gu4Zkfo39HuFegGDJYTBEiK85/2K6KW+Qvde33nd7nriE9ZtP4x24xzpRwZLCIMlxKa1wtXxFTvX4ybo2rE75s412Q8jB8eS/jBYQhgsIcJrhZW5EGLdrXsPK8QcUqoP1hPWZxtXgcbVP85gCWGwhAh/E3qFWAtL9XyvSNVAqZpm8u2gK+ex9DIGSwiDJUR4rfDq7e/craTWBIn9WKmeFKtr1fnEEsJgCWGwhAD7YxH7srvo3g1vGWfP+uCVTywhDJYQBksIcM/7zrWznf1FT/VKSL0LeeV+LL2MwRLCYAmx6Vs6qe/A0HvD6bW2U+9U7q+DfWIJYbCEMFhCBGqsnX2eiL1QlXFWx3Tvc4XucVUZx/1YegGDJYTBEgJ8r7Dye5/6RnL3XGJ/0qk+8t176J57j08sIQyWEAZLiPA8VuUYYq6L3seder+PQPQd9XuFeiiDJYTBEiIwj0V/f6Z7D6n9Ut37mczD7ezPvqdm9YklhMESwmAJEf5eIVHHpPpgPbmHFnHdSf3kPJYeymAJYbCEONAf69R7dk/o3bAap4J4p9LeDXoZgyWEwRICrLGuTn3jZWfPz8mYk3vY2S++zieWEAZLCIMlxIHeDal1w66d7/0RfSi6x6Tu5x6fWEIYLCEMlhDh3g2r3+nUXEuqbqNru+5eK7qv2Ir9sfQyBksIgyXEg/pjXaX2gxM9Rel3D7vndu3pK+ETSwiDJYTBEiL8XmHKpIZY2VmjPO27h/T3iz6McOMc6UcGSwiDJcTNeSy6BuoeQ+zBJ95D7N5D184+Wz+MHBxL+sNgCWGwhAisFRLv/VW+gVM5frIvavXn3f1hq3Em654rk7XLLJ9YQhgsIQyWEOH9WDt7JXT316fuJ7XulvomY2pO0d4NegGDJYTBEgLc807o1jGptT9iDTE195Za93StUC9gsIQwWEK8oMaavHM3qVdWxxPf5CHW+LrroZP7+XCV4fnSRwZLCIMlxKb+WCnEN3lW625P6MtVMVmLvMruwfeJJYTBEsJgCRGosYh3DFd29lufjEN892Zy3e68nfNYeiiDJYTBEuKh/bH0dj6xhDBYQhgsIQyWEAZLCIMlhMESwmAJYbCEMFhCGCwhDJYQBksIgyWEwRLCYAlhsIT4HybO2zx85W0PAAAAAElFTkSuQmCC';

    const QRCODEPHPABOVE72_V2 = 'data:image/png;base64,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';
}
