<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PageController;
use App\Http\Controllers\AuthController;

// Public routes
Route::get('/', [PageController::class, 'home'])->name('home');
Route::get('/about', [PageController::class, 'about'])->name('about');
Route::get('/brand_detail', [PageController::class, 'brand_detail'])->name('brand_detail');
Route::get('/careers', [PageController::class, 'careers'])->name('careers');
Route::get('/cart', [PageController::class, 'cart'])->name('cart');
Route::get('/checkout', [PageController::class, 'checkout'])->name('checkout');
Route::get('/contact', [PageController::class, 'contact'])->name('contact');
Route::get('/offer', [PageController::class, 'offer'])->name('offer');
Route::get('/privacy-policy', [PageController::class, 'privacy_policy'])->name('privacy-policy');
Route::get('/product-list', [PageController::class, 'product-list'])->name('product-list');
Route::get('/product-detial', [PageController::class, 'product-detial'])->name('product-detial');
Route::get('/product/{id}', [PageController::class, 'product_detial'])->name('product.detail');
Route::get('/thank-you', [PageController::class, 'thank-you'])->name('thank-you');
Route::get('/wishlist', [PageController::class, 'wishlist'])->name('wishlist');
Route::get('/track', [PageController::class, 'track'])->name('track');
Route::get('/products', [PageController::class, 'products'])->name('products');

// Authentication routes
Route::middleware('guest')->group(function () {
    Route::post('/login', [AuthController::class, 'login'])->name('login');
    Route::post('/register', [AuthController::class, 'register'])->name('register');
});

Route::middleware('auth')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
});
