@extends('layouts.app')

@section('content')


<nav class="dsdsd" aria-label="breadcrumb">
    <div class="container">
        <ol class="breadcrumb custom-breadcrumb">
            <li class="breadcrumb-item"><a href="#">Home</a></li>
            
            <li class="breadcrumb-item active" aria-current="page">Track Your Order</li>
        </ol>
    </div>
</nav>


  <section class="delivery-section">
    <div class="container">
      <div class="row align-items-center g-5">
        
        <!-- Left Text -->
        <div class="col-lg-6">
          <h2 class="delivery-title">Delivery Tracking</h2>
          <p class="delivery-text">
            If you can't find what you're looking for please jump on our live chat 
            and we'll be happy to help.
          </p>
        </div>

        <!-- Right Image -->
        <div class="col-lg-6 delivery-img text-center">
          <img src="https://images.pexels.com/photos/373548/pexels-photo-373548.jpeg" alt="Delivery Tracking">
        </div>

      </div>
    </div>
  </section>



  <!-- Track Order Section -->
  <section class="track-order-section d-flex align-items-center min-vh-100">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6">
          <div class="track-order-box bg-white p-5 shadow rounded">

            <h2 class="track-order-title mb-4 text-center">Track Your Order</h2>

            <form>
              <!-- Order Number -->
              <div class="mb-3">
                <label for="orderNumber" class="form-label track-order-label">Order Number</label>
                <p class="track-order-subtext">
                  You can find the order number in your order confirmation email or 
                  <a href="{{ route('login') }}" class="track-order-link">sign in your account</a>.
                </p>
                <input type="text" class="form-control track-order-input" id="orderNumber" placeholder="Enter your order number" />
              </div>

              <!-- Email -->
              <div class="mb-4">
                <label for="email" class="form-label track-order-label">Email Address</label>
                <input type="email" class="form-control track-order-input" id="email" placeholder="Enter your email address" />
              </div>

              <!-- Button -->
              <button type="submit" class="btn track-order-btn w-100">Track Your Order</button>
            </form>

          </div>
        </div>
      </div>
    </div>
  </section>
  
@endsection
