@extends('layouts.app')

@section('content')

<nav class="dsdsd" aria-label="breadcrumb">
    <div class="container">
        <ol class="breadcrumb custom-breadcrumb">
            <li class="breadcrumb-item"><a href="#">Home</a></li>
            
            <li class="breadcrumb-item active" aria-current="page">Offers</li>
        </ol>
    </div>
</nav>

<!-- September Saving Event Section -->
<section class="september-event-section py-5">
    <div class="container">
        <div class="row align-items-center">

            <!-- Left Content -->
            <div class="col-md-7">
                <h2 class="september-event-title">Up to 25% off September Saving Event</h2>
                <p class="september-event-desc">
                    Enjoy amazing discounts in our September Saving Event. Save up to 25% off on this range of selected
                    blinds, curtains and shutters. Save money, without compromising on style. Ends soon!
                </p>
                <div class="september-event-buttons d-flex flex-wrap gap-2">
                    <a href="#" class="btn btn-custom">Wooden Blinds</a>
                    <a href="#" class="btn btn-custom">Shutters</a>
                    <a href="#" class="btn btn-custom">White Blinds</a>
                </div>
            </div>

            <!-- Right Image -->
            <div class="col-md-5 mt-4 mt-md-0">
                <div class="september-event-image position-relative">
                    <img src="{{ asset('assets/img/Swift-Sept_Saving_Event-PLP_810x496.jpg') }}" alt="September Event"
                        class="img-fluid rounded">
                </div>
            </div>

        </div>
    </div>
</section>

<style>
/* Product Type Buttons */
.product-type-list {
    list-style: none;
    padding: 0;
    margin: 0;
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
    gap: 10px;
}

.product-type-list li {
    display: flex;
}

.type-btn {
    display: flex;
    justify-content: space-between;
    align-items: center;
    width: 100%;
    text-decoration: none;
    padding: 10px 14px;
    border: 1px solid #ddd;
    border-radius: 8px;
    font-size: 14px;
    color: #333;
    background: #fff;
    transition: all 0.3s ease;
}

.type-btn span {
    color: #777;
    font-size: 13px;
}

.type-btn:hover {
    background: #f8f9fa;
    border-color: #007bff;
    color: #007bff;
    transform: translateY(-2px);
    box-shadow: 0 3px 8px rgba(0, 0, 0, 0.08);
}
</style>

<section class="flat-spacing-24">
    <div class="container">
        <div class="row">
            <div class="col-xl-3">
                <div class="canvas-sidebar sidebar-filter canvas-filter left">
                    <div class="canvas-wrapper">
                        <div class="canvas-header d-flex d-xl-none">
                            <span class="title">Filter</span>
                            <span class="icon-close icon-close-popup close-filter"></span>
                        </div>
                        <div class="canvas-body">

                            <div class="widget-facet">
                                <div class="facet-title text-xl fw-medium" data-bs-target="#productType"
                                    data-bs-toggle="collapse" aria-expanded="true" aria-controls="productType">
                                    <span>Product Type</span>
                                    <span class="icon icon-arrow-up"></span>
                                </div>
                                <div id="productType" class="collapse show">
                                    <ul class="collapse-body product-type-list">
                                        <li><a href="#" class="type-btn">Roller Blind <span>(692)</span></a></li>
                                        <li><a href="#" class="type-btn">Venetian Blind <span>(392)</span></a></li>
                                        <li><a href="#" class="type-btn">Vertical Blind <span>(224)</span></a></li>
                                        <li><a href="#" class="type-btn">Roman Blind <span>(209)</span></a></li>

                                        <li><a href="#" class="type-btn">Panel Blind <span>(2)</span></a></li>
                                    </ul>
                                </div>
                            </div>

                            <div class="widget-facet">
                                <div class="facet-title text-xl fw-medium" data-bs-target="#availability" role="button"
                                    data-bs-toggle="collapse" aria-expanded="true" aria-controls="availability">
                                    <span>Pleated Type</span>
                                    <span class="icon icon-arrow-up"></span>
                                </div>
                                <div id="availability" class="collapse show">
                                    <ul class="collapse-body filter-group-check current-scrollbar">
                                        <li class="list-item">
                                            <input type="radio" name="availability" class="tf-check" id="inStock">
                                            <label for="inStock" class="label"><span>Bottom Up</span>&nbsp;<span
                                                    class="count">(24)</span></label>
                                        </li>
                                        <li class="list-item">
                                            <input type="radio" name="availability" class="tf-check" id="outStock">
                                            <label for="outStock" class="label"><span>Top Down Bottom Up
                                                    stock</span>&nbsp;<span class="count">(11)</span></label>
                                        </li>
                                    </ul>
                                </div>
                            </div>

                            <div class="widget-facet">
                                <div class="facet-title text-xl fw-medium" data-bs-target="#pattern" role="button"
                                    data-bs-toggle="collapse" aria-expanded="true" aria-controls="pattern">
                                    <span>Pattern</span>
                                    <span class="icon icon-arrow-up"></span>
                                </div>
                                <div id="pattern" class="collapse show">
                                    <ul class="collapse-body filter-group-check current-scrollbar">

                                        <li class="list-item d-flex align-items-center mb-2">
                                            <input type="radio" name="pattern" class="tf-check" id="plain">
                                            <label for="plain" class="label d-flex align-items-center">
                                                <img src="https://www.swiftdirectblinds.co.uk/media/attribute/swatch/swatch_image/30x20/p/a/pattern_plain.png"
                                                    alt="Plain" class="pattern-img me-2">
                                                <span>Plain</span>&nbsp;<span class="count">(1105)</span>
                                            </label>
                                        </li>

                                        <li class="list-item d-flex align-items-center mb-2">
                                            <input type="radio" name="pattern" class="tf-check" id="textured">
                                            <label for="textured" class="label d-flex align-items-center">
                                                <img src="https://www.swiftdirectblinds.co.uk/media/attribute/swatch/swatch_image/30x20/p/a/pattern_textured.png"
                                                    alt="Textured" class="pattern-img me-2">
                                                <span>Textured</span>&nbsp;<span class="count">(292)</span>
                                            </label>
                                        </li>

                                        <li class="list-item d-flex align-items-center mb-2">
                                            <input type="radio" name="pattern" class="tf-check" id="patterned">
                                            <label for="patterned" class="label d-flex align-items-center">
                                                <img src="https://www.swiftdirectblinds.co.uk/media/attribute/swatch/swatch_image/30x20/p/a/pattern_patterned.png"
                                                    alt="Patterned" class="pattern-img me-2">
                                                <span>Patterned</span>&nbsp;<span class="count">(201)</span>
                                            </label>
                                        </li>

                                        <li class="list-item d-flex align-items-center mb-2">
                                            <input type="radio" name="pattern" class="tf-check" id="floral">
                                            <label for="floral" class="label d-flex align-items-center">
                                                <img src="https://www.swiftdirectblinds.co.uk/media/attribute/swatch/swatch_image/30x20/p/a/pattern_floral.png"
                                                    alt="Floral" class="pattern-img me-2">
                                                <span>Floral</span>&nbsp;<span class="count">(137)</span>
                                            </label>
                                        </li>

                                        <li class="list-item d-flex align-items-center mb-2">
                                            <input type="radio" name="pattern" class="tf-check" id="geometric">
                                            <label for="geometric" class="label d-flex align-items-center">
                                                <img src="https://www.swiftdirectblinds.co.uk/media/attribute/swatch/swatch_image/30x20/p/a/pattern_geometric.png"
                                                    alt="Geometric" class="pattern-img me-2">
                                                <span>Geometric</span>&nbsp;<span class="count">(63)</span>
                                            </label>
                                        </li>

                                        <li class="list-item d-flex align-items-center mb-2">
                                            <input type="radio" name="pattern" class="tf-check" id="animal">
                                            <label for="animal" class="label d-flex align-items-center">
                                                <img src="https://www.swiftdirectblinds.co.uk/media/attribute/swatch/swatch_image/30x20/p/a/pattern_animal.png"
                                                    alt="Animal" class="pattern-img me-2">
                                                <span>Animal</span>&nbsp;<span class="count">(14)</span>
                                            </label>
                                        </li>

                                        <li class="list-item d-flex align-items-center mb-2">
                                            <input type="radio" name="pattern" class="tf-check" id="abstract">
                                            <label for="abstract" class="label d-flex align-items-center">
                                                <img src="https://www.swiftdirectblinds.co.uk/media/attribute/swatch/swatch_image/30x20/p/a/pattern_abstract.png"
                                                    alt="Abstract" class="pattern-img me-2">
                                                <span>Abstract</span>&nbsp;<span class="count">(9)</span>
                                            </label>
                                        </li>

                                    </ul>
                                </div>
                            </div>

                            <style>
                            .pattern-img {
                                width: 28px;
                                height: 28px;
                                border-radius: 50%;
                                object-fit: cover;
                            }
                            </style>

                            <div class="widget-facet">
                                <div class="facet-title text-xl fw-medium" data-bs-target="#price" role="button"
                                    data-bs-toggle="collapse" aria-expanded="true" aria-controls="price">
                                    <span>Price</span>
                                    <span class="icon icon-arrow-up"></span>
                                </div>
                                <div id="price" class="collapse show">
                                    <div class="collapse-body widget-price filter-price">
                                        <span class="reset-price">Reset</span>
                                        <div class="price-val-range" id="price-value-range" data-min="0" data-max="500">
                                        </div>
                                        <div class="box-value-price">
                                            <span class="text-sm">Price:</span>
                                            <div class="price-box">
                                                <div class="price-val" id="price-min-value" data-currency="$">
                                                </div>
                                                <span>-</span>
                                                <div class="price-val" id="price-max-value" data-currency="$">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="widget-facet">
                                <div class="facet-title text-xl fw-medium" data-bs-target="#color" role="button"
                                    data-bs-toggle="collapse" aria-expanded="true" aria-controls="color">
                                    <span>Color</span>
                                    <span class="icon icon-arrow-up"></span>
                                </div>
                                <div id="color" class="collapse show">
                                    <div class="collapse-body filter-color-box flat-check-list">
                                        <div class="check-item color-item color-check"><span
                                                class="color bg-yellow"></span><span class="color-text">Yellow</span>
                                        </div>
                                        <div class="check-item color-item color-check"><span
                                                class="color bg-dark"></span><span class="color-text">Black</span></div>
                                        <div class="check-item color-item color-check line"><span
                                                class="color bg-white"></span><span class="color-text">White</span>
                                        </div>
                                        <div class="check-item color-item color-check"><span
                                                class="color bg-purple-3"></span><span class="color-text">Purple</span>
                                        </div>
                                        <div class="check-item color-item color-check"><span
                                                class="color bg-light-orange"></span><span class="color-text">Light
                                                Orange</span></div>
                                        <div class="check-item color-item color-check"><span
                                                class="color bg-light-pink-4"></span><span class="color-text">Light
                                                Pink</span></div>
                                        <div class="check-item color-item color-check"><span
                                                class="color bg-pink"></span><span class="color-text">Pink</span></div>
                                        <div class="check-item color-item color-check"><span
                                                class="color bg-dark-green"></span><span class="color-text">Dark
                                                Green</span></div>
                                        <div class="check-item color-item color-check"><span
                                                class="color bg-grey-4"></span><span class="color-text">Grey</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="widget-facet">
                                <div class="facet-title text-xl fw-medium" data-bs-target="#size" role="button"
                                    data-bs-toggle="collapse" aria-expanded="true" aria-controls="size">
                                    <span>Size</span>
                                    <span class="icon icon-arrow-up"></span>
                                </div>
                                <div id="size" class="collapse show">
                                    <div class="collapse-body filter-size-box flat-check-list">
                                        <div class="check-item size-item size-check"><span
                                                class="size">25mm</span>&nbsp;<span class="count"> (157)</span>
                                        </div>
                                        <div class="check-item size-item size-check"><span class="size">50mm
                                            </span>&nbsp;<span class="count"> (87)</span>
                                        </div>
                                        <div class="check-item size-item size-check"><span class="size">35mm
                                            </span>&nbsp;<span class="count"> (47)</span>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <div class="widget-facet">
                                <div class="facet-title text-xl fw-medium" data-bs-target="#size" role="button"
                                    data-bs-toggle="collapse" aria-expanded="true" aria-controls="size">
                                    <span>Room</span>
                                    <span class="icon icon-arrow-up"></span>
                                </div>
                                <div id="size" class="collapse show">
                                    <div class="collapse-body filter-size-box flat-check-list">
                                        <div class="check-item size-item size-check"><span class="size">Conservatory
                                            </span>&nbsp;<span class="count">(840)</span>
                                        </div>
                                        <div class="check-item size-item size-check">
                                            <span class="size">Living Room</span>&nbsp;<span class="count">(808)</span>
                                        </div>
                                        <div class="check-item size-item size-check">
                                            <span class="size">Bedroom</span>&nbsp;<span class="count">(668)</span>
                                        </div>
                                        <div class="check-item size-item size-check">
                                            <span class="size">Dining Room</span>&nbsp;<span class="count">(593)</span>
                                        </div>
                                        <div class="check-item size-item size-check">
                                            <span class="size">Kitchen</span>&nbsp;<span class="count">(456)</span>
                                        </div>
                                        <div class="check-item size-item size-check">
                                            <span class="size">Office</span>&nbsp;<span class="count">(399)</span>
                                        </div>
                                        <div class="check-item size-item size-check">
                                            <span class="size">Bathroom</span>&nbsp;<span class="count">(254)</span>
                                        </div>
                                        <div class="check-item size-item size-check">
                                            <span class="size">Children</span>&nbsp;<span class="count">(129)</span>
                                        </div>
                                        <div class="check-item size-item size-check">
                                            <span class="size">Nursery</span>&nbsp;<span class="count">(65)</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-9">

                <div class="tf-shop-control">
                    <h4>Wooden Blinds</h4>
                    <div class="tf-group-filter">
                        <button id="filterShop" class="tf-btn-filter d-flex d-xl-none">
                            <span class="icon icon-filter"></span><span class="text">Filter</span>
                        </button>

                    </div>

                </div>

                <div class="wrapper-control-shop">

                    <div class="row g-4">

                        <div class="col-md-4 col-sm-6">
                            <div class="product-card">
                                <div class="product-img">
                                    <img src="{{ asset('assets/img/premier_bright_white.webp') }}" alt="Product">
                                    <span class="discount-badge">25% OFF</span>
                                </div>
                                <div class="product-body">
                                    <span class="delivery-tag">Next Day Delivery</span>
                                    <h5 class="product-title">Premier Bright White</h5>
                                    <p class="product-sub">Wooden Blind, Faux Wood</p>
                                    <p><span class="price">From £5.96</span> <span class="old-price">£7.95</span></p>
                                    <button class="sample-btn" onclick="window.location.href='product-detial.php'">
                                        Order Free Sample
                                    </button>

                                </div>
                            </div>
                        </div>

                        <!-- Product 2 -->
                        <div class="col-md-4 col-sm-6">
                            <div class="product-card">
                                <div class="product-img">
                                    <img src="{{ asset('assets/img/premier_taped_bright_white.webp') }}" alt="Product">
                                    <span class="discount-badge">25% OFF</span>
                                </div>
                                <div class="product-body">
                                    <span class="delivery-tag">Next Day Delivery</span>
                                    <h5 class="product-title">Premier Taped Bright White</h5>
                                    <p class="product-sub">Wooden Blind, Faux Wood</p>
                                    <p><span class="price">From £7.84</span> <span class="old-price">£10.45</span></p>
                                    <button class="sample-btn" onclick="window.location.href='product-detial.php'">
                                        Order Free Sample
                                    </button>

                                </div>
                            </div>
                        </div>

                        <!-- Product 3 -->
                        <div class="col-md-4 col-sm-6">
                            <div class="product-card">
                                <div class="product-img">
                                    <img src="{{ asset('assets/img/premier_bright_white_grained_50mm_.webp') }}" alt="Product">
                                    <span class="discount-badge">25% OFF</span>
                                </div>
                                <div class="product-body">
                                    <span class="delivery-tag">Next Day Delivery</span>
                                    <h5 class="product-title">Premier Grained Bright White</h5>
                                    <p class="product-sub">Wooden Blind, Faux Wood</p>
                                    <p><span class="price">From £5.96</span> <span class="old-price">£7.95</span></p>
                                    <button class="sample-btn" onclick="window.location.href='product-detial.php'">
                                        Order Free Sample
                                    </button>

                                </div>
                            </div>
                        </div>

                        <div class="col-md-4 col-sm-6">
                            <div class="product-card">
                                <div class="product-img">
                                    <img src="{{ asset('assets/img/premier_bright_white.webp') }}" alt="Product">
                                    <span class="discount-badge">25% OFF</span>
                                </div>
                                <div class="product-body">
                                    <span class="delivery-tag">Next Day Delivery</span>
                                    <h5 class="product-title">Premier Bright White</h5>
                                    <p class="product-sub">Wooden Blind, Faux Wood</p>
                                    <p><span class="price">From £5.96</span> <span class="old-price">£7.95</span></p>
                                    <button class="sample-btn" onclick="window.location.href='product-detial.php'">
                                        Order Free Sample
                                    </button>

                                </div>
                            </div>
                        </div>

                        <!-- Product 2 -->
                        <div class="col-md-4 col-sm-6">
                            <div class="product-card">
                                <div class="product-img">
                                    <img src="{{ asset('assets/img/premier_taped_bright_white.webp') }}" alt="Product">
                                    <span class="discount-badge">25% OFF</span>
                                </div>
                                <div class="product-body">
                                    <span class="delivery-tag">Next Day Delivery</span>
                                    <h5 class="product-title">Premier Taped Bright White</h5>
                                    <p class="product-sub">Wooden Blind, Faux Wood</p>
                                    <p><span class="price">From £7.84</span> <span class="old-price">£10.45</span></p>
                                    <button class="sample-btn" onclick="window.location.href='product-detial.php'">
                                        Order Free Sample
                                    </button>

                                </div>
                            </div>
                        </div>

                        <!-- Product 3 -->
                        <div class="col-md-4 col-sm-6">
                            <div class="product-card">
                                <div class="product-img">
                                    <img src="{{ asset('assets/img/premier_bright_white_grained_50mm_.webp') }}" alt="Product">
                                    <span class="discount-badge">25% OFF</span>
                                </div>
                                <div class="product-body">
                                    <span class="delivery-tag">Next Day Delivery</span>
                                    <h5 class="product-title">Premier Grained Bright White</h5>
                                    <p class="product-sub">Wooden Blind, Faux Wood</p>
                                    <p><span class="price">From £5.96</span> <span class="old-price">£7.95</span></p>
                                    <button class="sample-btn" onclick="window.location.href='product-detial.php'">
                                        Order Free Sample
                                    </button>

                                </div>
                            </div>
                        </div>

                        <div class="col-md-4 col-sm-6">
                            <div class="product-card">
                                <div class="product-img">
                                    <img src="{{ asset('assets/img/premier_bright_white.webp') }}" alt="Product">
                                    <span class="discount-badge">25% OFF</span>
                                </div>
                                <div class="product-body">
                                    <span class="delivery-tag">Next Day Delivery</span>
                                    <h5 class="product-title">Premier Bright White</h5>
                                    <p class="product-sub">Wooden Blind, Faux Wood</p>
                                    <p><span class="price">From £5.96</span> <span class="old-price">£7.95</span></p>
                                    <button class="sample-btn" onclick="window.location.href='product-detial.php'">
                                        Order Free Sample
                                    </button>

                                </div>
                            </div>
                        </div>

                        <!-- Product 2 -->
                        <div class="col-md-4 col-sm-6">
                            <div class="product-card">
                                <div class="product-img">
                                    <img src="{{ asset('assets/img/premier_taped_bright_white.webp') }}" alt="Product">
                                    <span class="discount-badge">25% OFF</span>
                                </div>
                                <div class="product-body">
                                    <span class="delivery-tag">Next Day Delivery</span>
                                    <h5 class="product-title">Premier Taped Bright White</h5>
                                    <p class="product-sub">Wooden Blind, Faux Wood</p>
                                    <p><span class="price">From £7.84</span> <span class="old-price">£10.45</span></p>
                                    <button class="sample-btn" onclick="window.location.href='product-detial.php'">
                                        Order Free Sample
                                    </button>

                                </div>
                            </div>
                        </div>

                        <!-- Product 3 -->
                        <div class="col-md-4 col-sm-6">
                            <div class="product-card">
                                <div class="product-img">
                                    <img src="{{ asset('assets/img/premier_bright_white_grained_50mm_.webp') }}" alt="Product">
                                    <span class="discount-badge">25% OFF</span>
                                </div>
                                <div class="product-body">
                                    <span class="delivery-tag">Next Day Delivery</span>
                                    <h5 class="product-title">Premier Grained Bright White</h5>
                                    <p class="product-sub">Wooden Blind, Faux Wood</p>
                                    <p><span class="price">From £5.96</span> <span class="old-price">£7.95</span></p>
                                    <button class="sample-btn" onclick="window.location.href='product-detial.php'">
                                        Order Free Sample
                                    </button>

                                </div>
                            </div>
                        </div>

                    </div>

                    <ul class="wg-pagination">
                        <li class="active">
                            <div class="pagination-item">1</div>
                        </li>
                        <li>
                            <a href="#" class="pagination-item">2</a>
                        </li>
                        <li>
                            <a href="#" class="pagination-item">3</a>
                        </li>
                        <li>
                            <a href="#" class="pagination-item"><i class="icon-arr-right2"></i></a>
                        </li>
                    </ul>

                </div>
            </div>
        </div>
    </div>
</section>

@endsection
