@extends('layouts.app')

@section('content')
  
<nav class="dsdsd" aria-label="breadcrumb">
    <div class="container">
        <ol class="breadcrumb custom-breadcrumb">
            <li class="breadcrumb-item"><a href="#">Home</a></li>

            <li class="breadcrumb-item active" aria-current="page">Offers</li>
        </ol>
    </div>
</nav>


<section class="brand-section">
    <div class="container">
        <!-- Logo Section -->
        <div class="brand-logo">
            <h1>
                <span style="font-size: 0.9rem; letter-spacing: 0.4rem;">THE</span>
                FABRIC BOX
            </h1>
        </div>

        <!-- Overview Section -->
        <div class="brand-overview">
            <h6>Overview</h6>
            <p>
                Discover a world of stylish and functional window solutions for roller and vertical blinds,
                crafted with precision and quality materials that transform windows into canvases of elegance –
                indulge in the art of window fashion.
            </p>
        </div>
    </div>
</section>




<section class="feature-section">
    <div class="container">
        <div class="row align-items-center g-5">
            <!-- Left Image -->
            <div class="col-lg-6 feature-image">
                <img src="{{ asset('assets/img/zafira-spice.png') }}" alt="Fabric Window Blinds">
            </div>

            <!-- Right Text -->
            <div class="col-lg-6">
                <div class="feature-text">
                    <h6>Features</h6>
                    <h2>Colour, intricate designs & captivating textures</h2>
                    <p>
                        Interior-led designs transform windows into expressions of elegance and personality.
                        From luxurious textures to versatile colour palettes, each fabric balances beauty and function.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="feature-section">
    <div class="container">
        <div class="row align-items-center g-5">


            <!-- Right Text -->
            <div class="col-lg-6">
                <div class="feature-text">
                    <h6>Features</h6>
                    <h2>Sustainability & Versatility</h2>
                    <p>
                        Emphasises recycling, innovative textile construction, and digital print technology to minimise
                        waste, water, and energy consumption. Every fabric is thoughtfully crafted to balance style with
                        eco-conscious design.
                    </p>
                </div>
            </div>

            <!-- Left Image -->
            <div class="col-lg-6 feature-image">
                <img src="{{ asset('assets/img/aki-meteor.jpg') }}" alt="Fabric Window Blinds">
            </div>

        </div>
    </div>
</section>




<section class="contact-section">
    <div class="container">
      <!-- Heading -->
      <h2>Want to know more about The Fabric Box?</h2>
      <p>Please leave your message</p>

      <!-- Contact Form -->
      <form class="contact-form">
        <input type="text" class="form-control" placeholder="Company">
        <input type="text" class="form-control" placeholder="Name">
        <input type="email" class="form-control" placeholder="Email">
        <textarea class="form-control" rows="5" placeholder="Message"></textarea>
        <button type="submit">Send</button>
      </form>
    </div>
  </section>
@endsection
