<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>{{ config('app.name', 'Blinds Market') }}</title>

    <meta name="author" content="themesflat.com">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="Blinds Market">

    <meta name="keywords" content="Blinds Market">
    <!-- CSRF token for AJAX -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <link rel="stylesheet" href="{{ asset('assets/fonts/fonts.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/fonts/font-icons.css') }}">

    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/swiper-bundle.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/animate.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/styles.css') }}">
     <link rel="stylesheet" href="{{ asset('assets/css/sib-styles.css') }}" >
    <link rel="stylesheet" href="{{ asset('assets/css/drift-basic.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/photoswipe.css') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="shortcut icon" href="{{ asset('assets/img/fav.jpeg') }}">
    <link rel="apple-touch-icon-precomposed" href="{{ asset('assets/img/fav.jpeg') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    @yield('styles')
</head>

<style>
small {
    font-size: 11px;
}
.invalid-field {
    border-color: #dc3545 !important;
}
</style>

<body>
    <!-- Success/Error Messages -->
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show position-fixed" style="top: 20px; right: 20px; z-index: 9999; max-width: 400px;" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif
    
    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show position-fixed" style="top: 20px; right: 20px; z-index: 9999; max-width: 400px;" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <!-- Scroll Top -->
    <button id="goTop">
        <span class="border-progress"></span>
        <span class="icon icon-arrow-right"></span>
    </button>

    <div id="wrapper">
        <!-- Header -->
        <header id="header" class="header-default header-search header-uppercase header-style-2">
            <div class="header-top">
                <div class="container">
                    <div class="row wrapper-header align-items-center">
                        <div class="col-md-4 col-3 d-xl-none">
                            <a href="#mobileMenu" class="mobile-menu" data-bs-toggle="offcanvas"
                                aria-controls="mobileMenu">
                                <i class="icon icon-categories1"></i>
                            </a>
                        </div>
                        <div class="col-xl-3 col-md-4 col-6">
                            <a href="{{ route('home') }}" class="logo-header">
                                <img src="{{ asset('assets/img/logo.png') }}" alt="logo" class="logo">
                            </a>
                        </div>
                        <div class="col-xl-5 d-none d-xl-block text-center">
                            <div class="tf-form-search">
                                <form class="form-search">
                                    <input type="text" placeholder="Search product" tabindex="0" aria-required="true"
                                        required="">
                                    <button type="submit" class="btn-search"><i class="icon icon-search"></i></button>
                                </form>

                            </div>
                        </div>

                        <div class="col-xl-4 col-md-4 col-3">
                            <ul class="nav-icon d-flex justify-content-end align-items-center">
                                <li class="nav-search d-xl-none d-flex">
                                    <a href="#search" data-bs-toggle="modal" class="nav-icon-item">
                                        <i class="icon icon-search"></i>
                                    </a>
                                </li>
                                <li class="nav-account">
                                    @auth
                                        <div class="dropdown" id="authArea">
                                            <a href="#" class="nav-icon-item dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i class="icon icon-user"></i>
                                                <span class="text d-none d-xl-block">{{ Auth::user()->name }}</span>
                                            </a>
                                            <ul class="dropdown-menu">
                                                <li><a class="dropdown-item" href="#">Profile</a></li>
                                                <li><a class="dropdown-item" href="{{ route('wishlist') }}">Wishlist</a></li>
                                                <li><a class="dropdown-item" href="{{ route('track') }}">Track Orders</a></li>
                                                <li><hr class="dropdown-divider"></li>
                                                <li>
                                                    <form method="POST" action="{{ route('logout') }}" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="dropdown-item">Logout</button>
                                                    </form>
                                                </li>
                                            </ul>
                                        </div>
                                    @else
                                        <div id="authArea">
                                            <a href="#login" data-bs-toggle="offcanvas" class="nav-icon-item">
                                                <i class="icon icon-user"></i>
                                                <span class="text d-none d-xl-block">Login</span>
                                            </a>
                                        </div>
                                    @endauth
                                </li>
                                <li class="nav-wishlist">
                                    <a  href="{{ route('wishlist') }}" class="nav-icon-item">
                                        <i class="icon icon-heart"></i>
                                        <span class="text d-none d-xl-block">Wishlist</span>
                                    </a>
                                </li>
                                <li class="nav-cart">
                                    <a href="#shoppingCart" data-bs-toggle="offcanvas" class="nav-icon-item">
                                        <i class="icon icon-cart"></i>
                                        <span class="text d-none d-xl-block">Cart</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="header-bottom d-none l d-xl-block">
                <div class="container">
                    <div class="wrapper-header-bottom">
                        <div class="inner-left">

                            <nav class="box-navigation text-center">
                                <ul class="box-nav-menu">
                                    <li class="menu-item"> <a  href="{{ route('home') }}"  class="item-link">Home</a></li>

                                    <li class="menu-item"> <a  href="{{ route('about') }}"  class="item-link">About Us</a></li>

                                    <li class="menu-item">
                                        <a href="#" class="item-link">Products<i class="icon icon-arr-down"></i></a>
                                        <div class="sub-menu mega-menu mega-product mega-productwww">
                                            <div class="wrapper-sub-menu">
                                                @if(isset($navigationCategories) && $navigationCategories->count() > 0)
                                                    @foreach($navigationCategories as $category)
                                                        <div class="mega-menu-item">
                                                            <div class="menu-heading">{{ $category->name }}</div>
                                                            <ul class="menu-list">
                                                                <li><a href="{{ route('products') }}?category={{ $category->id }}" class="menu-link-text link">{{ $category->name }}</a></li>
                                                                @if($category->children && $category->children->count() > 0)
                                                                    @foreach($category->children as $subcategory)
                                                                        <li><a href="{{ route('products') }}?category={{ $subcategory->id }}" class="menu-link-text link">{{ $subcategory->name }}</a></li>
                                                                    @endforeach
                                                                @endif
                                                            </ul>
                                                        </div>
                                                    @endforeach
                                                @else
                                                    <div class="mega-menu-item">
                                                        <div class="menu-heading">Products</div>
                                                        <ul class="menu-list">
                                                            <li><a href="{{ route('products') }}" class="menu-link-text link">All Products</a></li>
                                                        </ul>
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="wrapper-sub-product">
                                                <div dir="ltr" class="swiper tf-swiper wrap-sw-over" data-swiper='{
                                                        "slidesPerView": 2,
                                                        "spaceBetween": 24,
                                                        "speed": 800,
                                                        "observer": true,
                                                        "observeParents": true,
                                                        "slidesPerGroup": 2,
                                                        "navigation": {
                                                            "clickable": true,
                                                            "nextEl": ".nav-next-product-header",
                                                            "prevEl": ".nav-prev-product-header"
                                                        },
                                                        "pagination": { "el": ".sw-pagination-product-header", "clickable": true }
                                                    }'>
                                                    <div class="swiper-wrapper">
                                                        <!-- item 1 -->

                                                        <div class="swiper-slide">
                                                            <div class="card-product style-2 style-border-2">
                                                                <div class="card-product-wrapper asp-ratio-0">
                                                                    <a href="#" class="product-img">
                                                                        <img class="img-product lazyload"
                                                                            data-src="{{ asset('assets/img/memento.jpg') }}"
                                                                            src="{{ asset('assets/img/memento.jpg') }}"
                                                                            alt="image-product">
                                                                        <img class="img-hover lazyload"
                                                                            data-src="{{ asset('assets/img/memento.jpg') }}"
                                                                            src="{{ asset('assets/img/memento.jpg') }}"
                                                                            alt="image-product">
                                                                    </a>


                                                                </div>
                                                                <div class="card-product-info text-center">
                                                                    <a href="#"
                                                                        class="name-product link fw-medium text-md">Roller
                                                                        blinds for home</a>

                                                                </div>
                                                            </div>
                                                        </div>


                                                        <div class="swiper-slide">
                                                            <div class="card-product style-2 style-border-2">
                                                                <div class="card-product-wrapper asp-ratio-0">
                                                                    <a href="#" class="product-img">
                                                                        <img class="img-product lazyload"
                                                                            data-src="{{ asset('assets/img/1000_F_250036555_n0A78Ay2uxKKwvOGapp6lThP1n5ZWrE9-2-4.png') }}"
                                                                            src="{{ asset('assets/img/1000_F_250036555_n0A78Ay2uxKKwvOGapp6lThP1n5ZWrE9-2-4.png') }}"
                                                                            alt="image-product">
                                                                        <img class="img-hover lazyload"
                                                                            data-src="{{ asset('assets/img/1000_F_250036555_n0A78Ay2uxKKwvOGapp6lThP1n5ZWrE9-2-4.png') }}"
                                                                            src="{{ asset('assets/img/1000_F_250036555_n0A78Ay2uxKKwvOGapp6lThP1n5ZWrE9-2-4.png') }}"
                                                                            alt="image-product">
                                                                    </a>


                                                                </div>
                                                                <div class="card-product-info text-center">
                                                                    <a href="#"
                                                                        class="name-product link fw-medium text-md">Roof
                                                                        light roller blinds</a>

                                                                </div>
                                                            </div>
                                                        </div>


                                                        <div class="swiper-slide">
                                                            <div class="card-product style-2 style-border-2">
                                                                <div class="card-product-wrapper asp-ratio-0">
                                                                    <a href="#" class="product-img">
                                                                        <img class="img-product lazyload"
                                                                            data-src="{{ asset('assets/img/1000_F_250036555_n0A78Ay2uxKKwvOGapp6lThP1n5ZWrE9-2-5.png') }}"
                                                                            src="{{ asset('assets/img/1000_F_250036555_n0A78Ay2uxKKwvOGapp6lThP1n5ZWrE9-2-5.png') }}"
                                                                            alt="image-product">
                                                                        <img class="img-hover lazyload"
                                                                            data-src="{{ asset('assets/img/1000_F_250036555_n0A78Ay2uxKKwvOGapp6lThP1n5ZWrE9-2-5.png') }}"
                                                                            src="{{ asset('assets/img/1000_F_250036555_n0A78Ay2uxKKwvOGapp6lThP1n5ZWrE9-2-5.png') }}"
                                                                            alt="image-product">
                                                                    </a>


                                                                </div>
                                                                <div class="card-product-info text-center">
                                                                    <a href="#"
                                                                        class="name-product link fw-medium text-md">Duo
                                                                        roller blinds</a>

                                                                </div>
                                                            </div>
                                                        </div>


                                                    </div>
                                                    <div
                                                        class="sw-dot-default sw-pagination-product-header justify-content-center">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>

                                    <li class="menu-item ">
                                        <a href="#" class="item-link">Brands<i class="icon icon-arr-down"></i></a>
                                        <div class="sub-menu mega-menu mega-product dsfsff">
                                            <div class="wrapper-sub-menu">
                                                @if(isset($navigationBrands) && $navigationBrands->count() > 0)
                                                    @foreach($navigationBrands as $brand)
                                                        <div class="mega-menu-item">
                                                            <a href="{{ route('products') }}?brand={{ $brand->id }}">
                                                                <div class="menu-heading">
                                                                    @if($brand->logo)
                                                                        <i class="{{ $brand->logo }}"></i>
                                                                    @else
                                                                        <i class="fa-solid fa-window-maximize"></i>
                                                                    @endif
                                                                    {{ $brand->name }}
                                                                    @if($brand->description)
                                                                        <br><small>{{ $brand->description }}</small>
                                                                    @endif
                                                                </div>
                                                            </a>
                                                        </div>
                                                    @endforeach
                                                @else
                                                    <div class="mega-menu-item">
                                                        <a href="{{ route('products') }}">
                                                            <div class="menu-heading">
                                                                <i class="fa-solid fa-window-maximize"></i> No Brands Available
                                                                <br><small>Check back later</small>
                                                            </div>
                                                        </a>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </li>

                                    <li class="menu-item"><a href="{{ route('privacy-policy') }}" class="item-link">Policies</a></li>
                                    <li class="menu-item"><a href="{{ route('careers') }}" class="item-link">Careers</a></li>
                                    <li class="menu-item"><a href="{{ route('contact') }}" class="item-link">Contact</a></li>

                                </ul>
                            </nav>
                        </div>
                        <div class="inner-right">
                            <a href="{{ route('offer') }}" class="link fw-medium text-md text-white">Offers</a>
                            <a href="{{ route('track') }}" class="link fw-medium text-md text-white">Track your order</a>

                        </div>
                    </div>
                </div>
            </div>
        </header>

        <!-- Main Content -->
        <main>
            @yield('content')
        </main>

        <!-- Footer -->
        <footer class="footer-container">
            <div class="container">
                <div class="row">

                    <!-- Company Logo -->
                    <div class="col-lg-3">
                        <img src="{{ asset('assets/img/foot.png') }}" class="footer-logo" alt="Blinds Market">

                        <div class="codl mt-2">
                            <p>
                                At <strong>Blinds Market</strong>, we provide high-quality blinds, shutters, curtains,
                                and window systems designed to make every space stylish, practical, and comfortable.
                                From homes to commercial projects, our products are built with innovation, safety,
                                and durability in mind.
                            </p>
                        </div>
                    </div>

                    <!-- Help & Info -->
                    <div class="col-lg-2">
                        <h6>Help & Info</h6>
                        <a class="footer-faqs" href="#">FAQs</a>
                        <a class="footer-sizesure" href="#">Measuring Guide</a>
                        <a class="footer-delivery" href="#">Delivery Information</a>
                        <a class="footer-terms" href="#">Terms & Conditions</a>
                        <a class="footer-guarantee" href="#">5 Year Guarantee</a>
                        <a class="footer-samples" href="#">Request Free Samples</a>
                        <a class="footer-find-window" href="#">Find Your Window Covering</a>
                    </div>

                    <!-- How to Guides -->
                    <div class="col-lg-2">
                        <h6>How to Guides</h6>
                        <a class="footer-how-measure" href="#">How to Measure</a>
                        <a class="footer-how-install" href="#">How to Install</a>

                        <h6 class="mt-3">Customer Service</h6>
                        <a class="footer-track-order" href="{{ route('track') }}">Track My Order</a>
                        <a class="footer-contact-us" href="{{ route('contact') }}">Contact Us</a>
                    </div>

                    <!-- About Us -->
                    <div class="col-lg-2">
                        <h6>About Us</h6>
                        <a class="footer-about-us" href="{{ route('about') }}">About Blinds Market</a>
                        <a class="footer-history" href="#">Our Story</a>
                        <a class="footer-inspiration" href="#">Inspiration & Ideas</a>
                        <a class="footer-affiliate" href="#">Partner with Us</a>
                        <a class="footer-sitemap" href="#">Sitemap</a>
                    </div>

                    <!-- Get in Touch -->
                    <div class="col-lg-3">
                        <h6>Get in Touch</h6>
                        <div class="footer-contact-phone"><i class="fa fa-phone"></i> +44 (0) 123 456 7890</div>
                        <p class="footer-livechat"><strong>Live Chat Opening Times</strong><br>
                            9:00am – 5:30pm Monday–Friday<br>
                            9:00am – 3:00pm Saturdays
                        </p>
                        <p class="footer-phone-times"><strong>Phone Support</strong><br>
                            9:00am – 5:30pm Monday–Friday<br>
                            9:00am – 3:00pm Saturdays
                        </p>
                        <div class="footer-social mt-2">
                            <a href="#"><i class="fab fa-facebook"></i></a>
                            <a href="#"><i class="fab fa-instagram"></i></a>
                            <a href="#"><i class="fab fa-youtube"></i></a>
                            <a href="#"><i class="fab fa-linkedin"></i></a>
                        </div>
                    </div>

                </div>

                <!-- Payment Icons -->
                <div class="footer-payment text-center mt-4">
                    <img src="https://img.icons8.com/color/48/000000/visa.png" />
                    <img src="https://img.icons8.com/color/48/000000/mastercard.png" />
                    <img src="https://img.icons8.com/color/48/000000/amex.png" />
                    <img src="https://img.icons8.com/color/48/000000/paypal.png" />
                </div>

                <!-- Bottom Info -->
                <div class="footer-bottom mt-3 text-center">
                    © {{ date('Y') }} Blinds Market. All Rights Reserved.
                </div>
            </div>
        </footer>
    </div>
 </div>

    <!-- mobile menu -->
    <div class="offcanvas offcanvas-start canvas-mb" id="mobileMenu">
        <button class="icon-close icon-close-popup" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        <div class="mb-canvas-content">
            <div class="mb-body">
                <div class="mb-content-top">
                    <ul class="nav-ul-mb" id="wrapper-menu-navigation">
                    </ul>
                </div>
                <div class="mb-other-content">
                    <div class="group-icon">
                        <a href="#" class="site-nav-icon">
                            <i class="icon icon-heart"></i>
                            Wishlist
                        </a>
                        @auth
                            <div class="dropdown">
                                <a href="#" class="site-nav-icon dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="icon icon-user"></i>
                                    {{ Auth::user()->name }}
                                </a>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="#">Profile</a></li>
                                    <li><a class="dropdown-item" href="{{ route('wishlist') }}">Wishlist</a></li>
                                    <li><a class="dropdown-item" href="{{ route('track') }}">Track Orders</a></li>
                                    <li><hr class="dropdown-divider"></li>
                                    <li>
                                        <form method="POST" action="{{ route('logout') }}" class="d-inline">
                                            @csrf
                                            <button type="submit" class="dropdown-item">Logout</button>
                                        </form>
                                    </li>
                                </ul>
                            </div>
                        @else
                            <a href="#login" data-bs-toggle="offcanvas" class="site-nav-icon">
                                <i class="icon icon-user"></i>
                                Login
                            </a>
                        @endauth
                    </div>
                    <div class="mb-notice">
                        <a href="#" class="text-need">Need Help?</a>
                    </div>
                    <div class="mb-contact">
                        <p>Address: </p>
                    </div>
                    <ul class="mb-info">
                        <li>
                            Email:
                            <b class="fw-medium"></b>
                        </li>
                        <li>
                            Phone:
                            <b class="fw-medium"></b>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="mb-bottom">
                <div class="bottom-bar-language">
                    <div class="tf-currencies">
                        <select class="image-select center style-default type-currencies">
                            <option selected data-thumbnail="{{ asset('assets/img/country/us.png') }}">USD</option>
                            <option data-thumbnail="{{ asset('assets/img/country/fr.png') }}">EUR</option>
                            <option data-thumbnail="{{ asset('assets/img/country/ger.png') }}">EUR</option>
                            <option data-thumbnail="{{ asset('assets/img/country/vn.png') }}">VND</option>
                        </select>
                    </div>
                    <div class="tf-languages">
                        <select class="image-select center style-default type-languages">
                            <option>English</option>
                            <option>العربية</option>
                            <option>简体中文</option>
                            <option>اردو</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /mobile menu -->

    <!-- login -->
    <div class="offcanvas offcanvas-end popup-style-1 popup-login" id="login">
        <div class="canvas-wrapper">
            <div class="canvas-header popup-header">
                <span class="title">Log in</span>
                <button class="icon-close icon-close-popup" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>
            <div class="canvas-body popup-inner">
                <div id="login-errors" class="alert alert-danger d-none"></div>
                <div id="login-success" class="alert alert-success d-none"></div>
                <form id="login-form" method="POST" action="{{ route('login') }}" class="form-login">
                    @csrf
                    <div>
                        <fieldset class="email mb_12">
                            <input type="email" name="email" class="" placeholder="Email*" required>
                        </fieldset>
                        <fieldset class="password">
                            <input type="password" name="password" class="" placeholder="Password*" required>
                        </fieldset>
                        <fieldset class="mb_12">
                            <label class="d-flex align-items-center">
                                <input type="checkbox" name="remember" class="me-2">
                                <span class="text-sm">Remember Me</span>
                            </label>
                        </fieldset>
                    </div>
                    <div class="bot">
                        <a href="#resetPass" data-bs-toggle="offcanvas" class="text text-sm text-main-2">Forgot your
                            password?</a>
                        <div class="button-wrap">
                            <button class="subscribe-button tf-btn animate-btn d-inline-flex bg-dark-2 w-100"
                                type="submit">Sign in</button>
                            <button type="button" data-bs-target="#register" data-bs-toggle="offcanvas"
                                class="tf-btn btn-out-line-dark2 w-100">Create an account</button>
                        </div>
                    </div>
                </form>
                <div class="other-login">
                    <p class="text-sm text-center text-main-2">Or sign in with:</p>
                    <a href="#" class="w-100 text-md mb_8">
                        <svg class="icon" width="32" height="32" viewBox="0 0 32 32" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <circle cx="16" cy="16" r="16" fill="#3B5998" />
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M20.155 10.656L18.649 10.657C17.468 10.657 17.239 11.218 17.239 12.041V13.857H20.056L19.689 16.702H17.239V24H14.302V16.702H11.846V13.857H14.302V11.76C14.302 9.325 15.789 8 17.96 8C19 8 19.894 8.077 20.155 8.112V10.656ZM16 0C7.164 0 0 7.163 0 16C0 24.836 7.164 32 16 32C24.837 32 32 24.836 32 16C32 7.163 24.837 0 16 0Z"
                                fill="white" />
                        </svg>
                        FACEBOOK
                    </a>
                    <a href="#" class="w-100 text-md bg-dark">
                        <svg class="icon" width="32" height="32" viewBox="0 0 32 32" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_235_18876)">
                                <path
                                    d="M30.7919 13.218L17.7394 13.2174C17.163 13.2174 16.6958 13.6845 16.6958 14.2609V18.4306C16.6958 19.0068 17.163 19.4741 17.7393 19.4741H25.0897C24.2848 21.5629 22.7825 23.3122 20.8659 24.4237L24.0001 29.8493C29.0277 26.9416 32.0001 21.8398 32.0001 16.1287C32.0001 15.3155 31.9402 14.7342 31.8203 14.0796C31.7292 13.5823 31.2974 13.218 30.7919 13.218Z"
                                    fill="#167EE6" />
                                <path
                                    d="M16.0002 25.7392C12.4031 25.7392 9.26282 23.7738 7.57625 20.8655L2.15088 23.9926C4.91182 28.7777 10.0839 32 16.0002 32C18.9025 32 21.6411 31.2186 24.0002 29.8568V29.8494L20.866 24.4237C19.4324 25.2552 17.7734 25.7392 16.0002 25.7392Z"
                                    fill="#12B347" />
                                <path
                                    d="M24 29.8568V29.8493L20.8658 24.4237C19.4322 25.2551 17.7733 25.7391 16 25.7391V32C18.9023 32 21.641 31.2186 24 29.8568Z"
                                    fill="#0F993E" />
                                <path
                                    d="M6.26088 16C6.26088 14.2269 6.74475 12.5681 7.57606 11.1346L2.15069 8.00745C0.781375 10.3591 0 13.0903 0 16C0 18.9098 0.781375 21.6409 2.15069 23.9926L7.57606 20.8654C6.74475 19.4319 6.26088 17.7731 6.26088 16Z"
                                    fill="#FFD500" />
                                <path
                                    d="M16.0002 6.26088C18.3459 6.26088 20.5005 7.09437 22.1834 8.48081C22.5986 8.82281 23.2021 8.79813 23.5824 8.41781L26.5368 5.46344C26.9683 5.03194 26.9375 4.32562 26.4766 3.92575C23.6569 1.47956 19.9881 0 16.0002 0C10.0839 0 4.91182 3.22231 2.15088 8.00744L7.57625 11.1346C9.26282 8.22625 12.4031 6.26088 16.0002 6.26088Z"
                                    fill="#FF4B26" />
                                <path
                                    d="M22.1833 8.48081C22.5984 8.82281 23.2019 8.79813 23.5822 8.41781L26.5366 5.46344C26.968 5.03194 26.9373 4.32562 26.4764 3.92575C23.6567 1.4795 19.9879 0 16 0V6.26088C18.3456 6.26088 20.5003 7.09437 22.1833 8.48081Z"
                                    fill="#D93F21" />
                            </g>
                            <defs>
                                <clipPath>
                                    <rect width="32" height="32" fill="white" />
                                </clipPath>
                            </defs>
                        </svg>
                        GOOGLE
                    </a>
                </div>
            </div>
        </div>
    </div>
    <!-- /login -->

    <!-- register -->
    <div class="offcanvas offcanvas-end popup-style-1 popup-register" id="register">
        <div class="canvas-wrapper">
            <div class="canvas-header popup-header">
                <span class="title">Create account</span>
                <button class="icon-close icon-close-popup" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>
            <div class="canvas-body popup-inner">
                <div id="register-errors" class="alert alert-danger d-none"></div>
                <div id="register-success" class="alert alert-success d-none"></div>
                <form id="register-form" method="POST" action="{{ route('register') }}" class="form-login">
                    @csrf
                    <div class="">
                        <fieldset class="mb_12">
                            <input type="text" name="name" placeholder="Full Name*" required>
                        </fieldset>
                        <fieldset class="email mb_12">
                            <input type="email" name="email" placeholder="Email*" required>
                        </fieldset>
                        <fieldset class="password mb_12">
                            <input type="password" name="password" placeholder="Password*" required minlength="8">
                        </fieldset>
                        <fieldset class="password">
                            <input type="password" name="password_confirmation" placeholder="Confirm Password*" required minlength="8">
                        </fieldset>
                    </div>
                    <div class="bot">
                        <p class="text text-sm text-main-2">Sign up for early Sale access plus tailored new
                            arrivals, trends and promotions. To opt out, click unsubscribe in our emails.</p>
                        <div class="button-wrap">
                            <button class="subscribe-button tf-btn animate-btn bg-dark-2 w-100" type="submit">Sign
                                up</button>
                            <button type="button" data-bs-target="#login" data-bs-toggle="offcanvas"
                                class="tf-btn btn-out-line-dark2 w-100">Sign in</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- /register -->

    <!-- Reset pass -->
    <div class="offcanvas offcanvas-end popup-style-1 popup-reset-pass" id="resetPass">
        <div class="canvas-wrapper">
            <div class="canvas-header popup-header">
                <span class="title">Reset Your Password</span>
                <button class="icon-close icon-close-popup" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>
            <div class="canvas-body popup-inner">
                <form action="#" class="form-login">
                    <div class="">
                        <p class="text text-sm text-main-2">Forgot your password? No worries! Enter your registered
                            email to receive a link and securely reset it in just a few steps.</p>
                        <fieldset class="email mb_12">
                            <input type="email" placeholder="Enter Your Email*" required>
                        </fieldset>
                    </div>
                    <div class="bot">
                        <div class="button-wrap">
                            <button class="subscribe-button tf-btn animate-btn bg-dark-2 w-100" type="submit">Reset
                                Password</button>
                            <button type="button" data-bs-dismiss="offcanvas"
                                class="tf-btn btn-out-line-dark2 w-100">Cancel</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- /Reset pass -->

    <!-- search -->
    <div class="modal fade popup-search" id="search">
        <div class="modal-dialog modal-fullscreen">
            <div class="modal-content">
                <div class="header">
                    <button class="icon-close icon-close-popup" data-bs-dismiss="modal"></button>
                </div>
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-lg-8">
                            <div class="looking-for-wrap">
                                <div class="heading">What are you looking for?</div>
                                <form class="form-search">
                                    <fieldset class="text">
                                        <input type="text" placeholder="Search" class="" name="text" tabindex="0"
                                            value="" aria-required="true" required="">
                                    </fieldset>
                                    <button class="" type="submit">
                                        <i class="icon icon-search"></i>
                                    </button>
                                </form>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /search -->

    <!-- shoppingCart -->
    <div class="offcanvas offcanvas-end popup-style-1 popup-shopping-cart" id="shoppingCart">
        <div class="canvas-wrapper">
            <div class="popup-header">
                <span class="title">Shopping cart</span>
                <span class="icon-close icon-close-popup" data-bs-dismiss="offcanvas"></span>
            </div>
            <div class="wrap">
                <div class="tf-mini-cart-threshold">
                  
                    
                </div>
                <div class="tf-mini-cart-wrap">
                    <div class="tf-mini-cart-main">
                        <div class="tf-mini-cart-sroll">
                            <div class="tf-mini-cart-items">
                                <div class="tf-mini-cart-item file-delete">
                                    <div class="tf-mini-cart-image">
                                        <a href="{{ route('product-detial') }}">
                                            <img class="lazyload" data-src="{{ asset('assets/img/grey_blackout_roller_fully_closed_-_bedroom_23_.png') }}"
                                                src="{{ asset('assets/img/grey_blackout_roller_fully_closed_-_bedroom_23_.png') }}" alt="img-product">
                                        </a>
                                    </div>
                                    <div class="tf-mini-cart-info">
                                        <div class="d-flex justify-content-between">
                                            <a class="title link text-md fw-medium" href="{{ route('product-detial') }}">Premier Bright White</a>
                                            <i class="icon icon-close remove fs-12"></i>
                                        </div>
                                        
                                        <p class="price-wrap text-sm fw-medium">
                                            <span class="new-price text-primary">$130.00</span>
                                            <span
                                                class="old-price text-decoration-line-through text-dark-1">$150.00</span>
                                        </p>
                                        <div class="wg-quantity small">
                                            <button class="btn-quantity minus-btn">-</button>
                                            <input class="quantity-product font-4" type="text" name="number" value="1">
                                            <button class="btn-quantity plus-btn">+</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="tf-mini-cart-item file-delete">
                                    <div class="tf-mini-cart-image">
                                        <a href="{{ route('product-detial') }}">
                                            <img class="lazyload" data-src="{{ asset('assets/img/grey_blackout_roller_fully_closed_-_bedroom_23_.png') }}"
                                                src="{{ asset('assets/img/grey_blackout_roller_fully_closed_-_bedroom_23_.png') }}" alt="img-product">
                                        </a>
                                    </div>
                                    <div class="tf-mini-cart-info">
                                        <div class="d-flex justify-content-between">
                                            <a class="title link text-md fw-medium" href="{{ route('product-detial') }}">Premier Bright White</a>
                                            <i class="icon icon-close remove fs-12"></i>
                                        </div>
                                        
                                        <p class="price-wrap text-sm fw-medium">
                                            <span class="new-price text-primary">$130.00</span>
                                            <span
                                                class="old-price text-decoration-line-through text-dark-1">$150.00</span>
                                        </p>
                                        <div class="wg-quantity small">
                                            <button class="btn-quantity minus-btn">-</button>
                                            <input class="quantity-product font-4" type="text" name="number" value="1">
                                            <button class="btn-quantity plus-btn">+</button>
                                        </div>
                                    </div>
                                </div>
                                
                            </div>
                        
                        </div>
                    </div>
                    <div class="tf-mini-cart-bottom">
                    
                        <div class="tf-mini-cart-bottom-wrap">
                            <div class="tf-cart-totals-discounts">
                                <div class="tf-cart-total text-xl fw-medium">Total:</div>
                                <div class="tf-totals-total-value text-xl fw-medium">$130.00 USD</div>
                            </div>
                            <div class="tf-cart-tax text-sm opacity-8">Taxes and shipping calculated at checkout
                            </div>
                          
                            <div class="tf-mini-cart-view-checkout">
                                <a href="{{ route('checkout') }}"
                                    class="tf-btn animate-btn d-inline-flex bg-dark-2 w-100 justify-content-center"><span>Check
                                        out</span></a>
                                <a href="{{ route('cart') }}"
                                    class="tf-btn btn-out-line-dark2 w-100 justify-content-center">View cart</a>
                            </div>
                        </div>
                    </div>
                 
                    <div class="tf-mini-cart-tool-openable add-note">
                        <div class="overplay tf-mini-cart-tool-close"></div>
                        <form action="#" class="tf-mini-cart-tool-content">
                            <label for="Cart-note" class="tf-mini-cart-tool-text text-sm fw-medium">Order
                                note</label>
                            <textarea name="note" id="Cart-note" placeholder="Instruction for seller..."></textarea>
                            <div class="tf-cart-tool-btns">
                                <button class="subscribe-button tf-btn animate-btn d-inline-flex bg-dark-2 w-100"
                                    type="submit">Save</button>
                                <div class="tf-btn btn-out-line-dark2 w-100 tf-mini-cart-tool-close">Close</div>
                            </div>
                        </form>
                    </div>
                    <div class="tf-mini-cart-tool-openable coupon">
                        <div class="overplay tf-mini-cart-tool-close"></div>
                        <form action="#" class="tf-mini-cart-tool-content">
                            <div class="tf-mini-cart-tool-text text-sm fw-medium">Add coupon</div>
                            <div class="tf-mini-cart-tool-text1">* Discount will be calculated and
                                applied at checkout</div>
                            <input type="text" name="text" placeholder="">
                            <div class="tf-cart-tool-btns">
                                <button class="subscribe-button tf-btn animate-btn d-inline-flex bg-dark-2 w-100"
                                    type="submit">Save</button>
                                <div class="tf-btn btn-out-line-dark2 w-100 tf-mini-cart-tool-close">Close</div>
                            </div>
                        </form>
                    </div>
                    <div class="tf-mini-cart-tool-openable estimate-shipping">
                        <div class="overplay tf-mini-cart-tool-close"></div>
                        <form id="shipping-form" class="tf-mini-cart-tool-content">
                            <div class="tf-mini-cart-tool-text text-sm fw-medium">Shipping estimates</div>
                            <div class="field">
                                <p class="text-sm">Country</p>
                                <div class="tf-select">
                                    <select class="w-100" id="shipping-country-form" name="address[country]"
                                        data-default="">
                                        <option value="Australia"
                                            data-provinces='[["Australian Capital Territory","Australian Capital Territory"],["New South Wales","New South Wales"],["Northern Territory","Northern Territory"],["Queensland","Queensland"],["South Australia","South Australia"],["Tasmania","Tasmania"],["Victoria","Victoria"],["Western Australia","Western Australia"]]' >
                                            Australia</option>
                                        <option value="Austria" data-provinces='[]'>Austria</option>
                                        <option value="Belgium" data-provinces='[]'>Belgium</option>
                                        <option value="Canada"
                                            data-provinces='[["Ontario","Ontario"],["Quebec","Quebec"]]'>Canada
                                        </option>
                                        <option value="Czech Republic" data-provinces='[]'>Czechia</option>
                                        <option value="Denmark" data-provinces='[]'>Denmark</option>
                                        <option value="Finland" data-provinces='[]'>Finland</option>
                                        <option value="France" data-provinces='[]'>France</option>
                                        <option value="Germany" data-provinces='[]'>Germany</option>
                                        <option selected value="United States"
                                            data-provinces='[["Alabama","Alabama"],["California","California"],["Florida","Florida"]]' >
                                            United States</option>
                                        <option value="United Kingdom"
                                            data-provinces='[["England","England"],["Scotland","Scotland"],["Wales","Wales"],["Northern Ireland","Northern Ireland"]]' >
                                            United Kingdom</option>
                                        <option value="India" data-provinces='[]'>India</option>
                                        <option value="Japan" data-provinces='[]'>Japan</option>
                                        <option value="Mexico" data-provinces='[]'>Mexico</option>
                                        <option value="South Korea" data-provinces='[]'>South Korea</option>
                                        <option value="Spain" data-provinces='[]'>Spain</option>
                                        <option value="Italy" data-provinces='[]'>Italy</option>
                                        <option value="Vietnam"
                                            data-provinces='[["Ha Noi","Ha Noi"],["Da Nang","Da Nang"],["Ho Chi Minh","Ho Chi Minh"]]' >
                                            Vietnam</option>
                                    </select>
                                </div>
                            </div>
                            <div class="field">
                                <p class="text-sm">State/Province</p>
                                <div class="tf-select">
                                    <select id="shipping-province-form" name="address[province]"
                                        data-default=""></select>
                                </div>
                            </div>
                            <div class="field">
                                <p class="text-sm">Zipcode</p>
                                <input type="text" data-opend-focus id="zipcode" name="address[zip]" value="">
                            </div>
                            <div id="zipcode-message" class="error" style="display: none;">
                                We found one shipping rate available for undefined.
                            </div>
                            <div id="zipcode-success" class="success" style="display: none;">
                                <p>We found one shipping rate available for your address:</p>
                                <p class="standard">Standard at <span>$0.00</span> USD</p>
                            </div>
                            <div class="tf-cart-tool-btns">
                                <button class="subscribe-button tf-btn animate-btn d-inline-flex bg-dark-2 w-100"
                                    type="submit">Estimate</button>
                                <div
                                    class="tf-mini-cart-tool-primary tf-btn btn-out-line-dark2 w-100 tf-mini-cart-tool-close">
                                    Close</div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /shoppingCart -->

    <!-- Scripts (consolidated) -->
    <script src="{{ asset('assets/js/jquery.min.js') }}"></script>
    <script src="{{ asset('assets/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('assets/js/swiper-bundle.min.js') }}"></script>
    <script src="{{ asset('assets/js/carousel.js') }}"></script>
    <script src="{{ asset('assets/js/bootstrap-select.min.js') }}"></script>
    <script src="{{ asset('assets/js/lazysize.min.js') }}"></script>
    <script src="{{ asset('assets/js/count-down.js') }}"></script>
    <script src="{{ asset('assets/js/wow.min.js') }}"></script>
    <script src="{{ asset('assets/js/multiple-modal.js') }}"></script>
    <script src="{{ asset('assets/js/drift.min.js') }}"></script>
    <script src="{{ asset('assets/js/nouislider.min.js') }}"></script>
    <script src="{{ asset('assets/js/shop.js') }}"></script>
    <script src="{{ asset('assets/js/photoswipe-lightbox.umd.min.js') }}"></script>
    <script src="{{ asset('assets/js/photoswipe.umd.min.js') }}"></script>
    <script src="{{ asset('assets/js/zoom.js') }}"></script>
    <script src="{{ asset('assets/js/main.js') }}"></script>
    <script src="{{ asset('assets/js/sibforms.js') }}" defer></script>

    @yield('scripts')
    
    <!-- Authentication Scripts (improved) -->
    <script>
    (function () {
        // Helpers
        const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '';

        // password regex: min 8, 1 uppercase, 1 lowercase, 1 digit, 1 special char
        const passwordRegex = /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{8,}$/;

        function clearNode(node) {
            if (!node) return;
            node.classList.add('d-none');
            node.innerHTML = '';
        }

        function showNode(node, html) {
            if (!node) return;
            node.innerHTML = html;
            node.classList.remove('d-none');
        }

        function mapServerErrors(errors) {
            // Accept both object {field: ['msg']} and array ['msg']
            if (!errors) return { summary: [], fields: {} };
            const result = { summary: [], fields: {} };
            if (Array.isArray(errors)) {
                result.summary = errors;
            } else {
                for (const key in errors) {
                    const val = errors[key];
                    if (Array.isArray(val)) {
                        result.fields[key] = val[0];
                    } else if (typeof val === 'string') {
                        result.fields[key] = val;
                    } else {
                        // fallback push to summary
                        result.summary.push(String(val));
                    }
                }
            }
            return result;
        }

        function setFieldErrorByName(form, fieldName, message) {
            if (!form) return;
            const el = form.querySelector(`[name="${fieldName}"]`);
            if (el) {
                el.classList.add('invalid-field');
                // show inline small message after field if not present
                let feedback = el.nextElementSibling;
                if (!feedback || !feedback.classList || !feedback.classList.contains('form-field-feedback')) {
                    feedback = document.createElement('div');
                    feedback.className = 'form-field-feedback text-danger small mt-1';
                    el.parentNode.insertBefore(feedback, el.nextSibling);
                }
                feedback.textContent = message;
            }
        }

        function clearFieldErrors(form) {
            if (!form) return;
            form.querySelectorAll('.invalid-field').forEach(el => el.classList.remove('invalid-field'));
            form.querySelectorAll('.form-field-feedback').forEach(el => el.remove());
        }

        async function postForm(form) {
            const url = form.action;
            // Use FormData for file/normal support
            const fd = new FormData(form);
            // Send as JSON only if you prefer, but FormData is okay for Laravel (it will work).
            const headers = {
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': csrfToken,
                'Accept': 'application/json'
            };
            const resp = await fetch(url, {
                method: 'POST',
                headers,
                body: fd
            });
            let json = {};
            try { json = await resp.json(); } catch (e) { json = {}; }
            return { ok: resp.ok, status: resp.status, json };
        }

        // Update auth area (after successful login/register)
        function updateAuthArea(username) {
            const authArea = document.getElementById('authArea');
            if (!authArea) return;
            authArea.innerHTML = `
                <div class="dropdown">
                    <a href="#" class="nav-icon-item dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="icon icon-user"></i>
                        <span class="text d-none d-xl-block">${username}</span>
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="#">Profile</a></li>
                        <li><a class="dropdown-item" href="{{ route('wishlist') }}">Wishlist</a></li>
                        <li><a class="dropdown-item" href="{{ route('track') }}">Track Orders</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <form method="POST" action="{{ route('logout') }}" class="d-inline">
                                <input type="hidden" name="_token" value="${csrfToken}">
                                <button type="submit" class="dropdown-item">Logout</button>
                            </form>
                        </li>
                    </ul>
                </div>
            `;
        }

        // LOGIN
        const loginForm = document.getElementById('login-form');
        if (loginForm) {
            loginForm.addEventListener('submit', async function (e) {
                e.preventDefault();
                clearFieldErrors(loginForm);
                clearNode(document.getElementById('login-errors'));
                clearNode(document.getElementById('login-success'));

                const submitBtn = loginForm.querySelector('button[type="submit"]');
                const originalText = submitBtn ? submitBtn.textContent : 'Signing in...';

                // Basic client validation
                const email = loginForm.querySelector('input[name="email"]');
                const password = loginForm.querySelector('input[name="password"]');
                const errs = [];
                if (!email || !email.value || !/^\S+@\S+\.\S+$/.test(email.value)) errs.push('Valid email is required.');
                if (!password || !password.value) errs.push('Password is required.');
                if (errs.length) {
                    showNode(document.getElementById('login-errors'), '<ul class="mb-0"><li>' + errs.join('</li><li>') + '</li></ul>');
                    return;
                }

                if (submitBtn) {
                    submitBtn.disabled = true;
                    submitBtn.textContent = 'Signing in...';
                }

                const { ok, json } = await postForm(loginForm);

                if (ok && json && json.success) {
                    // Success: hide offcanvas and update navbar
                    showNode(document.getElementById('login-success'), json.message || 'Logged in successfully');
                    // Hide the offcanvas
                    const offEl = document.getElementById('login');
                    const off = bootstrap.Offcanvas.getInstance(offEl) || new bootstrap.Offcanvas(offEl);
                    off.hide();

                    // Update auth area if server returned username
                    const username = json.username || (json.user && json.user.name) || '';
                    if (username) updateAuthArea(username);
					     location.reload();

                } else {
                    // parse errors
                    const errors = mapServerErrors(json && json.errors ? json.errors : (json && json.error ? json.error : null));
                    if (Object.keys(errors.fields || {}).length) {
                        for (const k in errors.fields) {
                            setFieldErrorByName(loginForm, k, errors.fields[k]);
                        }
                    }
                    if (errors.summary && errors.summary.length) {
                        showNode(document.getElementById('login-errors'), '<ul class="mb-0"><li>' + errors.summary.join('</li><li>') + '</li></ul>');
                    } else if (json && json.message) {
                        showNode(document.getElementById('login-errors'), '<div>' + json.message + '</div>');
                    } else {
                        showNode(document.getElementById('login-errors'), '<div>An error occurred. Please try again.</div>');
                    }
                }

                if (submitBtn) {
                    submitBtn.disabled = false;
                    submitBtn.textContent = originalText;
                }
            });
        }

        // REGISTER
        const registerForm = document.getElementById('register-form');
        if (registerForm) {
            registerForm.addEventListener('submit', async function (e) {
                e.preventDefault();
                clearFieldErrors(registerForm);
                clearNode(document.getElementById('register-errors'));
                clearNode(document.getElementById('register-success'));

                // Fetch values
                const nameEl = registerForm.querySelector('input[name="name"]');
                const emailEl = registerForm.querySelector('input[name="email"]');
                const passEl = registerForm.querySelector('input[name="password"]');
                const passConfirmEl = registerForm.querySelector('input[name="password_confirmation"]');

                const clientErrors = [];
                if (!nameEl || !nameEl.value.trim()) clientErrors.push('Full name is required.');
                if (!emailEl || !emailEl.value || !/^\S+@\S+\.\S+$/.test(emailEl.value)) clientErrors.push('Valid email is required.');
                if (!passEl || !passwordRegex.test(passEl.value)) clientErrors.push('Password must be at least 8 characters, include uppercase, lowercase, number and special character.');
                if (passEl && passConfirmEl && passEl.value !== passConfirmEl.value) clientErrors.push('Passwords do not match.');

                if (clientErrors.length) {
                    showNode(document.getElementById('register-errors'), '<ul class="mb-0"><li>' + clientErrors.join('</li><li>') + '</li></ul>');
                    return;
                }

                const submitBtn = registerForm.querySelector('button[type="submit"]');
                const originalText = submitBtn ? submitBtn.textContent : 'Creating account...';
                if (submitBtn) {
                    submitBtn.disabled = true;
                    submitBtn.textContent = 'Creating account...';
                }

                const { ok, json } = await postForm(registerForm);

                if (ok && json && json.success) {
                    showNode(document.getElementById('register-success'), json.message || 'Account created successfully!');
                    registerForm.reset();

                    // Hide offcanvas
                    const offEl = document.getElementById('register');
                    const off = bootstrap.Offcanvas.getInstance(offEl) || new bootstrap.Offcanvas(offEl);
                    setTimeout(() => off.hide(), 800);

                    // Update auth area if server returned username
                    const username = json.username || (json.user && json.user.name);
                    if (username) updateAuthArea(username);
					     location.reload();

                } else {
                    const errors = mapServerErrors(json && json.errors ? json.errors : (json && json.error ? json.error : null));
                    if (Object.keys(errors.fields || {}).length) {
                        for (const k in errors.fields) {
                            setFieldErrorByName(registerForm, k, errors.fields[k]);
                        }
                    }
                    if (errors.summary && errors.summary.length) {
                        showNode(document.getElementById('register-errors'), '<ul class="mb-0"><li>' + errors.summary.join('</li><li>') + '</li></ul>');
                    } else if (json && json.message) {
                        showNode(document.getElementById('register-errors'), '<div>' + json.message + '</div>');
                    } else {
                        showNode(document.getElementById('register-errors'), '<div>An error occurred. Please try again.</div>');
                    }
                }

                if (submitBtn) {
                    submitBtn.disabled = false;
                    submitBtn.textContent = originalText;
                }
            });
        }

        // Clear form errors when popup is closed
        const loginOffEl = document.getElementById('login');
        if (loginOffEl) {
            loginOffEl.addEventListener('hidden.bs.offcanvas', function () {
                clearFieldErrors(loginForm);
                clearNode(document.getElementById('login-errors'));
                clearNode(document.getElementById('login-success'));
                if (loginForm) loginForm.reset();
				    
            });
        }
        const registerOffEl = document.getElementById('register');
        if (registerOffEl) {
            registerOffEl.addEventListener('hidden.bs.offcanvas', function () {
                clearFieldErrors(registerForm);
                clearNode(document.getElementById('register-errors'));
                clearNode(document.getElementById('register-success'));
                if (registerForm) registerForm.reset();
				     
            });
        }
    })();
    </script>
</body>
</html>
