<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ProductsTableSeeder extends Seeder {
    public function run() {
        $brands = DB::table('brands')->pluck('id')->toArray();
        $categories = DB::table('categories')->pluck('id')->toArray();

        DB::table('products')->insert([
            'brand_id' => $brands[0] ?? null,
            'category_id' => $categories[0] ?? null,
            'name' => 'How to Videos',
            'slug' => 'how-to-videos',
            'short_description' => 'How to Videos',
            'description' => 'How to Videos imported from project',
            'price' => 5.96,
            'stock' => 10,
            'is_active' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        DB::table('products')->insert([
            'brand_id' => $brands[0] ?? null,
            'category_id' => $categories[0] ?? null,
            'name' => 'How to Guides',
            'slug' => 'how-to-guides',
            'short_description' => 'How to Guides',
            'description' => 'How to Guides imported from project',
            'price' => 0,
            'stock' => 10,
            'is_active' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        DB::table('products')->insert([
            'brand_id' => $brands[0] ?? null,
            'category_id' => $categories[0] ?? null,
            'name' => 'Save 10% On Your First Purchase',
            'slug' => 'save-10-on-your-first-purchase',
            'short_description' => 'Save 10% On Your First Purchase',
            'description' => 'Save 10% On Your First Purchase imported from project',
            'price' => 0,
            'stock' => 10,
            'is_active' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // Add sample products for navigation
        $rollerBlindsCategory = DB::table('categories')->where('slug', 'roller-blinds-for-home')->first();
        $roofLightCategory = DB::table('categories')->where('slug', 'roof-light-roller-blinds')->first();
        $duoRollerCategory = DB::table('categories')->where('slug', 'duo-roller-blinds')->first();

        if ($rollerBlindsCategory) {
            DB::table('products')->insert([
                'brand_id' => $brands[0] ?? null,
                'category_id' => $rollerBlindsCategory->id,
                'name' => 'Roller blinds for home',
                'slug' => 'roller-blinds-for-home-product',
                'short_description' => 'High-quality roller blinds perfect for home use',
                'description' => 'Premium roller blinds designed for residential use with various fabric options and colors.',
                'price' => 89.99,
                'stock' => 50,
                'is_active' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        if ($roofLightCategory) {
            DB::table('products')->insert([
                'brand_id' => $brands[0] ?? null,
                'category_id' => $roofLightCategory->id,
                'name' => 'Roof light roller blinds',
                'slug' => 'roof-light-roller-blinds-product',
                'short_description' => 'Specialized roller blinds for roof lights and skylights',
                'description' => 'Custom-made roller blinds specifically designed for roof lights and skylights with UV protection.',
                'price' => 149.99,
                'stock' => 25,
                'is_active' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        if ($duoRollerCategory) {
            DB::table('products')->insert([
                'brand_id' => $brands[0] ?? null,
                'category_id' => $duoRollerCategory->id,
                'name' => 'Duo roller blinds',
                'slug' => 'duo-roller-blinds-product',
                'short_description' => 'Innovative duo roller blinds with day and night functionality',
                'description' => 'Modern duo roller blinds featuring alternating transparent and opaque stripes for versatile light control.',
                'price' => 119.99,
                'stock' => 35,
                'is_active' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        DB::table('products')->insert([
            'brand_id' => $brands[0] ?? null,
            'category_id' => $categories[0] ?? null,
            'name' => 'Wooden Blinds',
            'slug' => 'wooden-blinds',
            'short_description' => 'Wooden Blinds',
            'description' => 'Wooden Blinds imported from project',
            'price' => 0,
            'stock' => 10,
            'is_active' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        DB::table('products')->insert([
            'brand_id' => $brands[0] ?? null,
            'category_id' => $categories[0] ?? null,
            'name' => 'Premier Bright White',
            'slug' => 'premier-bright-white',
            'short_description' => 'Premier Bright White',
            'description' => 'Premier Bright White imported from project',
            'price' => 5.96,
            'stock' => 10,
            'is_active' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        DB::table('products')->insert([
            'brand_id' => $brands[0] ?? null,
            'category_id' => $categories[0] ?? null,
            'name' => 'Premier Taped Bright White',
            'slug' => 'premier-taped-bright-white',
            'short_description' => 'Premier Taped Bright White',
            'description' => 'Premier Taped Bright White imported from project',
            'price' => 7.84,
            'stock' => 10,
            'is_active' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        DB::table('products')->insert([
            'brand_id' => $brands[0] ?? null,
            'category_id' => $categories[0] ?? null,
            'name' => 'Premier Grained Bright White',
            'slug' => 'premier-grained-bright-white',
            'short_description' => 'Premier Grained Bright White',
            'description' => 'Premier Grained Bright White imported from project',
            'price' => 5.96,
            'stock' => 10,
            'is_active' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        DB::table('products')->insert([
            'brand_id' => $brands[0] ?? null,
            'category_id' => $categories[0] ?? null,
            'name' => 'The Perfect Shade for Every Room',
            'slug' => 'the-perfect-shade-for-every-room',
            'short_description' => 'The Perfect Shade for Every Room',
            'description' => 'The Perfect Shade for Every Room imported from project',
            'price' => 0,
            'stock' => 10,
            'is_active' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        DB::table('products')->insert([
            'brand_id' => $brands[0] ?? null,
            'category_id' => $categories[0] ?? null,
            'name' => 'Shop by Colour',
            'slug' => 'shop-by-colour',
            'short_description' => 'Shop by Colour',
            'description' => 'Shop by Colour imported from project',
            'price' => 0,
            'stock' => 10,
            'is_active' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

    }
}
