<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CategoriesTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('categories')->insert([
            [
                'name' => 'Roller Blinds',
                'slug' => 'roller-blinds',
                'parent_id' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'name' => 'Roman & Curtains',
                'slug' => 'roman-curtains',
                'parent_id' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'name' => 'Vertical Blinds',
                'slug' => 'vertical-blinds',
                'parent_id' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'name' => 'Venetians',
                'slug' => 'venetians',
                'parent_id' => null,
                'created_at' => now(),
                'updated_at' => now()
            ]
        ]);

        // Get parent category IDs for subcategories
        $rollerBlindsId = DB::table('categories')->where('slug', 'roller-blinds')->first()->id;
        $romanCurtainsId = DB::table('categories')->where('slug', 'roman-curtains')->first()->id;
        $verticalBlindsId = DB::table('categories')->where('slug', 'vertical-blinds')->first()->id;
        $venetiansId = DB::table('categories')->where('slug', 'venetians')->first()->id;

        // Insert subcategories
        DB::table('categories')->insert([
            // Roller Blinds subcategories
            [
                'name' => 'Roller blinds for home',
                'slug' => 'roller-blinds-for-home',
                'parent_id' => $rollerBlindsId,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'name' => 'Roof light roller blinds',
                'slug' => 'roof-light-roller-blinds',
                'parent_id' => $rollerBlindsId,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'name' => 'Duo roller blinds',
                'slug' => 'duo-roller-blinds',
                'parent_id' => $rollerBlindsId,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'name' => 'Contract and wide-width Roller Blinds',
                'slug' => 'contract-wide-width-roller-blinds',
                'parent_id' => $rollerBlindsId,
                'created_at' => now(),
                'updated_at' => now()
            ],

            // Roman & Curtains subcategories
            [
                'name' => 'Roman Blinds & Curtains',
                'slug' => 'roman-blinds-curtains',
                'parent_id' => $romanCurtainsId,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'name' => 'Voiles Curtain Collection',
                'slug' => 'voiles-curtain-collection',
                'parent_id' => $romanCurtainsId,
                'created_at' => now(),
                'updated_at' => now()
            ],

            // Vertical Blinds subcategories
            [
                'name' => 'Vertical blinds for home',
                'slug' => 'vertical-blinds-for-home',
                'parent_id' => $verticalBlindsId,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'name' => 'Rigid PVC vertical blinds',
                'slug' => 'rigid-pvc-vertical-blinds',
                'parent_id' => $verticalBlindsId,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'name' => 'Commercial Vertical Blinds',
                'slug' => 'commercial-vertical-blinds',
                'parent_id' => $verticalBlindsId,
                'created_at' => now(),
                'updated_at' => now()
            ],

            // Venetians subcategories
            [
                'name' => 'Timberlux real wood venetian blinds',
                'slug' => 'timberlux-real-wood-venetian-blinds',
                'parent_id' => $venetiansId,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'name' => 'Sunwood wood and faux wood venetian blinds',
                'slug' => 'sunwood-wood-faux-wood-venetian-blinds',
                'parent_id' => $venetiansId,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'name' => 'Aluminium venetian blinds',
                'slug' => 'aluminium-venetian-blinds',
                'parent_id' => $venetiansId,
                'created_at' => now(),
                'updated_at' => now()
            ]
        ]);
    }
}