<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up() {
        if (!Schema::hasTable('attributes')) {
    Schema::create('attributes', function (Blueprint $table) {
$table->id();
            $table->string('name');
            $table->string('slug')->nullable()->unique();
            $table->timestamps();
        
    });
}

        if (!Schema::hasTable('attribute_values')) {
    Schema::create('attribute_values', function (Blueprint $table) {
$table->id();
            $table->unsignedBigInteger('attribute_id');
            $table->string('value');
            $table->timestamps();

            $table->foreign('attribute_id')->references('id')->on('attributes')->onDelete('cascade');
        
    });
}

        if (!Schema::hasTable('product_attribute_value')) {
    Schema::create('product_attribute_value', function (Blueprint $table) {
$table->unsignedBigInteger('product_id');
            $table->unsignedBigInteger('attribute_value_id');
            $table->primary(['product_id','attribute_value_id']);
            $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
            $table->foreign('attribute_value_id')->references('id')->on('attribute_values')->onDelete('cascade');
        
    });
}
    }
    public function down() {
        Schema::dropIfExists('product_attribute_value');
        Schema::dropIfExists('attribute_values');
        Schema::dropIfExists('attributes');
    }
};
