<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up() {
        if (!Schema::hasTable('coupons')) {
    Schema::create('coupons', function (Blueprint $table) {
$table->id();
            $table->string('code')->unique();
            $table->enum('type', ['percentage','fixed'])->default('fixed');
            $table->decimal('value', 10,2)->default(0);
            $table->integer('usage_limit')->nullable();
            $table->integer('used_count')->default(0);
            $table->timestamp('starts_at')->nullable();
            $table->timestamp('ends_at')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        
    });
}
    }
    public function down() { Schema::dropIfExists('coupons'); }
};
