<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up() {
        if (!Schema::hasTable('offers')) {
    Schema::create('offers', function (Blueprint $table) {
$table->id();
            $table->string('title');
            $table->text('description')->nullable();
            $table->enum('type', ['percentage','fixed'])->default('percentage');
            $table->decimal('value', 10, 2)->default(0);
            $table->unsignedBigInteger('product_id')->nullable();
            $table->unsignedBigInteger('brand_id')->nullable();
            $table->decimal('min_order_value', 10, 2)->nullable();
            $table->timestamp('starts_at')->nullable();
            $table->timestamp('ends_at')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            $table->foreign('product_id')->references('id')->on('products')->onDelete('set null');
            $table->foreign('brand_id')->references('id')->on('brands')->onDelete('set null');
        
    });
}
    }
    public function down() { Schema::dropIfExists('offers'); }
};
