<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use App\Models\Brand;
use App\Models\Category;
use App\Models\Product;

class ViewServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Share navigation data with all views
        View::composer('layouts.app', function ($view) {
            $brands = Brand::all();
            $categories = Category::with('children')->whereNull('parent_id')->get();
            $featuredProducts = Product::with('category')->where('is_active', 1)->take(6)->get();
            
            $view->with([
                'navigationBrands' => $brands,
                'navigationCategories' => $categories,
                'navigationProducts' => $featuredProducts
            ]);
        });
    }
}