<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class Product extends Model {
    protected $fillable = [
        'brand_id','category_id','name','slug',
        'short_description','description','price','stock','sku','is_active'
    ];

    public function brand() { return $this->belongsTo(Brand::class); }
    public function category() { return $this->belongsTo(Category::class); }
    public function images() { return $this->hasMany(ProductImage::class); }
    public function primaryImage() { return $this->hasOne(ProductImage::class)->where('is_primary', true); }
    public function variants() { return $this->hasMany(ProductVariant::class); }
    public function attributes() { 
        return $this->belongsToMany(AttributeValue::class, 'product_attribute_value', 'product_id', 'attribute_value_id');
    }
    public function reviews() { return $this->hasMany(Review::class); }
    
    // Helper methods for ratings
    public function averageRating() {
        return $this->reviews()->avg('rating') ?? 0;
    }
    
    public function totalReviews() {
        return $this->reviews()->count();
    }
}
