<?php
namespace App\Http\Controllers;
use App\Models\Product;
use Illuminate\Http\Request;

class ProductController extends Controller {
    public function index(Request $r){
        $q = Product::with('brand','category','primaryImage','variants','attributes');
        if ($r->filled('brand')) $q->where('brand_id', $r->brand);
        if ($r->filled('category')) $q->where('category_id', $r->category);
        if ($r->filled('q')) $q->where('name','like','%'.$r->q.'%');
        return $q->paginate(12);
    }

    public function show($id){
        return Product::with('brand','category','images','variants','attributes')->findOrFail($id);
    }

    public function store(Request $r){
        $data = $r->validate([
            'name'=>'required|string',
            'price'=>'required|numeric',
            'brand_id'=>'nullable|exists:brands,id',
            'category_id'=>'nullable|exists:categories,id'
        ]);
        $product = Product::create($data);
        return response()->json($product,201);
    }

    public function update(Request $r, $id){
        $product = Product::findOrFail($id);
        $product->update($r->only(['name','price','short_description','description','stock','is_active','brand_id','category_id']));
        return response()->json($product);
    }

    public function destroy($id){
        Product::findOrFail($id)->delete();
        return response()->json(null,204);
    }
}
