<?php
namespace App\Http\Controllers;
use App\Models\Category;
use Illuminate\Http\Request;

class CategoryController extends Controller {
    public function index(){ return Category::with('children')->paginate(20); }
    public function show($id){ return Category::with('children','products')->findOrFail($id); }
    public function store(Request $r){ $data = $r->validate(['name'=>'required']); $cat = Category::create($data); return response()->json($cat,201); }
    public function update(Request $r,$id){ $cat = Category::findOrFail($id); $cat->update($r->only(['name','slug','parent_id'])); return response()->json($cat); }
    public function destroy($id){ Category::findOrFail($id)->delete(); return response()->json(null,204); }
}
