<?php
namespace App\Http\Controllers;
use App\Models\Brand;
use Illuminate\Http\Request;

class BrandController extends Controller {
    public function index() { return Brand::paginate(20); }
    public function show($id) { return Brand::findOrFail($id); }
    public function store(Request $r) {
        $data = $r->validate(['name'=>'required|string|max:255','slug'=>'nullable|string']);
        $brand = Brand::create($data);
        return response()->json($brand,201);
    }
    public function update(Request $r,$id){
        $brand = Brand::findOrFail($id);
        $data = $r->only(['name','slug','description','logo']);
        $brand->update($data);
        return response()->json($brand);
    }
    public function destroy($id){ Brand::findOrFail($id)->delete(); return response()->json(null,204); }
}
