<?php

namespace App\Filament\Resources\Products\Schemas;

use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Repeater;
use Filament\Schemas\Schema;
use App\Models\Brand;
use App\Models\Category;

class ProductForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('brand_id')
                    ->label('Brand')
                    ->options(Brand::all()->pluck('name', 'id'))
                    ->searchable()
                    ->placeholder('Select a brand'),
                Select::make('category_id')
                    ->label('Category')
                    ->options(Category::all()->pluck('name', 'id'))
                    ->searchable()
                    ->placeholder('Select a category'),
                TextInput::make('name')
                    ->required(),
                TextInput::make('slug')
                    ->default(null),
                Textarea::make('short_description')
                    ->default(null)
                    ->columnSpanFull(),
                Textarea::make('description')
                    ->default(null)
                    ->columnSpanFull(),
                TextInput::make('price')
                    ->required()
                    ->numeric()
                    ->default(0.0)
                    ->prefix('$'),
                TextInput::make('stock')
                    ->required()
                    ->numeric()
                    ->default(0),
                TextInput::make('sku')
                    ->label('SKU')
                    ->default(null),
                Toggle::make('is_active')
                    ->required(),
                
                // Product Images Section
                Repeater::make('images')
                    ->relationship('images')
                    ->schema([
                        FileUpload::make('image_path')
                            ->label('Image')
                            ->image()
                            ->disk('public')
                            ->directory('products')
                            ->visibility('public')
                            ->required(),
                        TextInput::make('alt_text')
                            ->label('Alt Text')
                            ->placeholder('Image description'),
                        Toggle::make('is_primary')
                            ->label('Primary Image')
                            ->default(false)
                            ->helperText('Only one image should be marked as primary'),
                    ])
                    ->columns(3)
                    ->defaultItems(1)
                    ->addActionLabel('Add Image')
                    ->collapsible()
                    ->itemLabel(fn (array $state): ?string => $state['alt_text'] ?? 'Product Image'),
            ]);
    }
}
