<?php
// Read data from Bhojpuri.json
$bhojpuriData = file_get_contents('Bhojpuri.json');
$bhojpuriArray = json_decode($bhojpuriData, true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $jsonArray = $bhojpuriArray;

    // Process submitted table data
    foreach ($_POST['table_data'] as $rowData) {
        $image = trim($rowData['image']);
        $link = trim($rowData['link']);
        $name = trim($rowData['name']);

        // Only add data if at least one field is not empty
        if ($image !== '' || $link !== '' || $name !== '') {
            $movieData = array(
                "image" => $image,
                "link" => $link,
                "name" => $name
            );
            array_push($jsonArray, $movieData);
        }
    }

    // Convert the array to JSON format with unescaped slashes
    $jsonContent = json_encode($jsonArray, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

    // Specify the path and filename for the JSON file
    $jsonFilePath = 'abc.json';

    // Write the JSON content to the file
    file_put_contents($jsonFilePath, $jsonContent);

    echo "JSON file 'abc.json' created and saved successfully.";
}

if (isset($_GET['delete_index'])) {
    $deleteIndex = intval($_GET['delete_index']);
    if ($deleteIndex >= 0 && $deleteIndex < count($bhojpuriArray)) {
        array_splice($bhojpuriArray, $deleteIndex, 1);
        // Convert the array to JSON format with unescaped slashes
        $jsonContent = json_encode($bhojpuriArray, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
        file_put_contents('Bhojpuri.json', $jsonContent);
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Create JSON File</title>
</head>
<body>
    <h2>Bhojpuri Movies Data</h2>
    <table border="1">
        <tr>
            <th>Image</th>
            <th>Link</th>
            <th>Name</th>
            <th>Action</th>
        </tr>
        <?php foreach ($bhojpuriArray as $index => $movie): ?>
            <tr>
                <td><img src="<?= $movie['image'] ?>" width="100"></td>
                <td><?= $movie['link'] ?></td>
                <td><?= $movie['name'] ?></td>
                <td><a href="?delete_index=<?= $index ?>">Delete</a></td>
            </tr>
        <?php endforeach; ?>
    </table>

    <h2>Create JSON File</h2>
    <form method="POST">
        <table>
            <tr>
                <th>Image</th>
                <th>Link</th>
                <th>Name</th>
            </tr>
            <tr>
                <td><input type="text" name="table_data[0][image]"></td>
                <td><input type="text" name="table_data[0][link]"></td>
                <td><input type="text" name="table_data[0][name]"></td>
            </tr>
            <!-- Add more rows for additional data -->
        </table>
        <input type="submit" value="Create JSON File">
    </form>
</body>
</html>
