
async function loadAWSConfig() {
    try {
        const response = await fetch("https://eortv.com/config");
        const awsConfig = await response.json();
        AWS.config.update({
            accessKeyId: awsConfig.accessKeyId,
            secretAccessKey: awsConfig.secretAccessKey,
            region: awsConfig.region
        });
        console.log("AWS Config Loaded Successfully:");
    } catch (error) {
        console.error("Error fetching AWS Config:", error);
    }
}

loadAWSConfig();

const docClient = new AWS.DynamoDB.DocumentClient();

const params = {
    TableName: 'scripts',
};

docClient.scan(params, (err, data) => {
    if (err) {
        console.error("Unable to scan the table. Error JSON:", JSON.stringify(err, null, 2));
    } else {
        console.log("Scan succeeded.");
        data.Items.forEach((item) => {
            if (item.status == "OPEN") {
                document.getElementById("tbody").innerHTML += `
            <tr>
                <td class="mg" data-label="Type:">${item.type} </td>
                <td class="mg" data-label="Topic:">${item.topic} </td>
                <td class="mg" data-label="Description:">${item.description} </td>
                <td class="mg" data-label="Dusration:">${item.duration} </td>
                <td class="mg" data-label="Deadline:">${item.deadline} </td>
                <td class="mg3" data-label="Status:">
                <div class="mg4" style="background-color:green">OPEN</div></td>
                <td class="mg2" data-label="Results:">${item.results} </td>
                <td class="file-input" data-label="Upload:"><input type="file" id="${item.details}">
                <button onclick="submitted('${item.details}')" class="submit-button" type="submit">SUBMIT</button>
                </td>
            </tr>`
            }
            if (item.status == "CLOSED") {
                document.getElementById("tbody").innerHTML += `
            <tr>
                <td class="mg" data-label="Type:">${item.type} </td>
                <td class="mg" data-label="Topic:">${item.topic} </td>
                <td class="mg" data-label="Description:">${item.description} </td>
                <td class="mg" data-label="Duration:">${item.duration} </td>
                <td class="mg" data-label="Deadline:">${item.deadline} </td>
                <td class="mg3" data-label="Status:">
                <div class="mg4" style="background-color:red">CLOSED</div></td>
                <td class="mg2" data-label="Results:">${item.results} </td>
                <td class="mg3" data-label="Upload:">
                Sorry, Not Accepting New Submissions </td>
            </tr>`
            }
        });
    }
});

function submitted(codescript) {
    const userConfirmed = confirm("Are you sure you want to submit? This action cannot be undone, edited, or deleted.");
    if (userConfirmed) {
        const fileInput = document.getElementById(codescript);
        const file = fileInput.files[0];
        if (!file) {
            alert('Please attach a file before submitting.');
            return;
        }
        const maxSizeMB = 5;
        const maxSizeBytes = maxSizeMB * 1024 * 1024;
        if (file.size > maxSizeBytes) {
            alert('File size exceeds 5MB. Please choose a smaller file.');
            return;
        }

        const eortvParams = {
            TableName: 'eortv',
            Key: {
                'eortv_media': uid
            }
        };

        docClient.get(eortvParams, (err, data) => {
            if (err) {
                console.error("Error querying 'Eortv' table:", JSON.stringify(err, null, 2));
                alert('Failed to verify agreement status. Please try again.');
            } else {
                if (data.Item && data.Item.writer) {
                    const timestamp = Date.now();
                    const fileName = `${uid}_${codescript}_${timestamp}.pdf`;

                    const s3 = new AWS.S3();
                    const uploadParams = {
                        Bucket: 'eortok',
                        Key: fileName,
                        Body: file,
                        ContentType: 'application/pdf'
                    };

                    s3.upload(uploadParams, (err, s3Data) => {
                        if (err) {
                            console.error('Error uploading file to S3:', err);
                            alert('Failed to upload file.');
                        } else {
                            const fileUrl = s3Data.Location;
                            console.log('File uploaded successfully:', fileUrl);

                            const updateEortvParams = {
                                TableName: 'eortv',
                                Key: {
                                    'eortv_media': uid
                                },
                                UpdateExpression: `set writer_${codescript} = :fileUrl`,
                                ExpressionAttributeValues: {
                                    ':fileUrl': fileUrl
                                }
                            };

                            docClient.update(updateEortvParams, (err, data) => {
                                if (err) {
                                    console.error("Error updating 'eortv' table:", JSON.stringify(err, null, 2));
                                    alert('Failed to update the eortv table.');
                                } else {
                                    console.log("Eortv table updated successfully.");

                                    const updateScriptsParams = {
                                        TableName: 'scripts',
                                        Key: {
                                            'details': codescript
                                        },
                                        UpdateExpression: `set #uid = :fileUrl`,
                                        ExpressionAttributeNames: {
                                            '#uid': uid
                                        },
                                        ExpressionAttributeValues: {
                                            ':fileUrl': fileUrl
                                        }
                                    };

                                    docClient.update(updateScriptsParams, (err, data) => {
                                        if (err) {
                                            console.error("Error updating 'scripts' table:", JSON.stringify(err, null, 2));
                                            alert('Failed to update the scripts table.');
                                        } else {
                                            console.log("Scripts table updated successfully.");
                                            alert("Thank You! Your Submission Was Uploaded Successfully For " + codescript);
                                        }
                                    });
                                }
                            });
                        }
                    });
                } else {
                    alert('Please submit the signed agreement before proceeding.');
                }
            }
        });
    } else {
        alert('Submission canceled.');
    }
}

let checkUidInterval = setInterval(() => {
    if (typeof uid !== 'undefined') {
        console.log(uid);
        console.log('UID found:', uid);
        clearInterval(checkUidInterval);
        const eortvParams = {
            TableName: 'eortv',
            Key: {
                'eortv_media': uid
            }
        };

        docClient.get(eortvParams, (err, data) => {
            if (err) {
                console.error("Error querying 'Eortv' table:", JSON.stringify(err, null, 2));
            } else {
                if (data.Item && data.Item.writer) {
                    console.log('Writer found:', data.Item.writer);
                    document.getElementById("uploaddoc").style.display = "none"
                    document.getElementById("viewdoc").style.display = "block"
                } else {
                    console.log('No writer key found in the item.');
                    document.getElementById("uploaddoc").style.display = "block"
                    document.getElementById("viewdoc").style.display = "none"
                }
            }
        });
    }
}, 100);


function uploaddoc() {
    const fileInput = document.getElementById('signeddoc');
    const file = fileInput.files[0];

    if (!file) {
        alert('Please select a file to upload.');
        return;
    }

    const maxSizeMB = 3;
    const maxSizeBytes = maxSizeMB * 1024 * 1024;
    if (file.size > maxSizeBytes) {
        alert('File size exceeds 3MB. Please choose a smaller file.');
        return;
    }

    if (file.type !== 'application/pdf') {
        alert('Only PDF files are allowed.');
        return;
    }

    const timestamp = Date.now();
    const fileName = `sign_${uid}_${timestamp}.pdf`;

    const s3 = new AWS.S3();
    const uploadParams = {
        Bucket: 'eortok',
        Key: fileName,
        Body: file,
        ContentType: 'application/pdf'
    };

    s3.upload(uploadParams, (err, data) => {
        if (err) {
            console.error('Error uploading file to S3:', err);
            alert('Failed to upload file.');
        } else {
            const fileUrl = data.Location;
            console.log('File uploaded successfully:', fileUrl);

            const updateParams = {
                TableName: 'eortv',
                Key: {
                    'eortv_media': uid
                },
                UpdateExpression: 'SET writer = :url',
                ExpressionAttributeValues: {
                    ':url': fileUrl
                }
            };

            docClient.update(updateParams, (err, data) => {
                if (err) {
                    console.error("Error updating 'eortv' table:", JSON.stringify(err, null, 2));
                    alert('Failed to update DynamoDB.');
                } else {
                    alert('Agreement Uploaded Successfully');
                    location.reload()
                }
            });
        }
    });
}

document.getElementById("downloadButton2").addEventListener("click", function () {
    const downloadLink = document.createElement("a");
    downloadLink.href = "https://eortv.com/eortv_writer_agreement.docx";
    downloadLink.download = "eortv_writer_agreement.docx";
    downloadLink.click();
});