
async function loadAWSConfig() {
    try {
        const response = await fetch("https://eortv.com/config");
        const awsConfig = await response.json();
        AWS.config.update({
            accessKeyId: awsConfig.accessKeyId,
            secretAccessKey: awsConfig.secretAccessKey,
            region: awsConfig.region
        });
        console.log("AWS Config Loaded Successfully:");
    } catch (error) {
        console.error("Error fetching AWS Config:", error);
    }
}

loadAWSConfig();

const docClient = new AWS.DynamoDB.DocumentClient();

const params = {
    TableName: 'producers',
};

docClient.scan(params, (err, data) => {
    if (err) {
        console.error("Unable to scan the table. Error JSON:", JSON.stringify(err, null, 2));
    } else {
        console.log("Scan succeeded.");
        data.Items.forEach((item) => {
            if (item.status == "OPEN") {
                document.getElementById("tbody").innerHTML += `
            <tr>
                <td class="mg"data-label="Topic:">${item.topic} </td>
                <td class="mg"data-label="Script:"><a style="color:white;font-weight:700" href="${item.script}">Click To View Script</a></td>
                <td class="mg"data-label="Budget:">${item.budget} </td> 
                <td class="mg"data-label="Deadline:">${item.deadline} </td>
                <td class="mg3" data-label="Status:">
              <div class="mg4" style="background-color:green">OPEN</div></td>
                 <td class="file-input" data-label="Upload:"><input type="file"><button onclick="submitted()" class="submit-button" type="submit">SUBMIT</button>
                </td>  <td data-label="Samples (Please Share Youtube/Google Drive Links)	:"><input type="text" style="margin-left:10px;height:50px;background-color:black;border:1px solid green;" placeholder="Add Links Here"><button onclick="submitted()" class="submit-button" type="submit">SUBMIT</button>
                </td> <td class="mg2" data-label="Results">${item.results} </td>

            </tr>`
            }
            if (item.status == "CLOSED") {
                document.getElementById("tbody").innerHTML += `
           <tr>
                <td class="mg"data-label="Topic:">${item.topic} </td>
                <td class="mg"data-label="Script:"><a style="color:white;font-weight:700" href="${item.script}">Click To View Script</a></td>
                <td class="mg"data-label="Budget:">${item.budget} </td> 
                <td class="mg"data-label="Deadline:">${item.deadline} </td>
                <td class="mg3" data-label="Status:">
              <div class="mg4" style="background-color:red">CLOSED</div></td>
                 <td class="file-input" data-label="Upload:"><input type="file"><button onclick="submitted()" class="submit-button" type="submit">SUBMIT</button>
                </td>  <td data-label="Samples (Please Share Youtube/Google Drive Links)	:"><input type="text" style="margin-left:10px;height:50px;background-color:black;border:1px solid green;" placeholder="Add Links Here"><button onclick="submitted()" class="submit-button" type="submit">SUBMIT</button>
                </td> <td class="mg2" data-label="Results">${item.results} </td>

            </tr>`


            }
        });
    }
});

function submitted() {
    alert("Thank You! Your Submission Was Uploaded Succesfully")
}



let checkUidInterval = setInterval(() => {
    if (typeof uid !== 'undefined') {
        console.log(uid);
        console.log('UID found:', uid);
        clearInterval(checkUidInterval);
        const eortvParams = {
            TableName: 'eortv',
            Key: {
                'eortv_media': uid
            }
        };

        docClient.get(eortvParams, (err, data) => {
            if (err) {
                console.error("Error querying 'Eortv' table:", JSON.stringify(err, null, 2));
            } else {
                if (data.Item && data.Item.producer) {
                    console.log('producer found:', data.Item.producer);
                    document.getElementById("uploaddoc").style.display = "none"
                    document.getElementById("viewdoc").style.display = "block"
                } else {
                    console.log('No producer key found in the item.');
                    document.getElementById("uploaddoc").style.display = "block"
                    document.getElementById("viewdoc").style.display = "none"
                }
            }
        });
    }
}, 100);




function uploaddoc() {
    const fileInput = document.getElementById('signeddoc');
    const file = fileInput.files[0];

    if (!file) {
        alert('Please select a file to upload.');
        return;
    }

    const maxSizeMB = 3;
    const maxSizeBytes = maxSizeMB * 1024 * 1024;
    if (file.size > maxSizeBytes) {
        alert('File size exceeds 3MB. Please choose a smaller file.');
        return;
    }

    if (file.type !== 'application/pdf') {
        alert('Only PDF files are allowed.');
        return;
    }

    const timestamp = Date.now();
    const fileName = `sign_${uid}_${timestamp}.pdf`;

    const s3 = new AWS.S3();
    const uploadParams = {
        Bucket: 'eortok',
        Key: fileName,
        Body: file,
        ContentType: 'application/pdf'
    };

    s3.upload(uploadParams, (err, data) => {
        if (err) {
            console.error('Error uploading file to S3:', err);
            alert('Failed to upload file.');
        } else {
            const fileUrl = data.Location;
            console.log('File uploaded successfully:', fileUrl);

            const updateParams = {
                TableName: 'eortv',
                Key: {
                    'eortv_media': uid
                },
                UpdateExpression: 'SET producer = :url',
                ExpressionAttributeValues: {
                    ':url': fileUrl
                }
            };

            docClient.update(updateParams, (err, data) => {
                if (err) {
                    console.error("Error updating 'eortv' table:", JSON.stringify(err, null, 2));
                    alert('Failed to update DynamoDB.');
                } else {
                    alert('Agreement Uploaded Successfully');
                    location.reload()
                }
            });
        }
    });
}

document.getElementById("downloadButton2").addEventListener("click", function () {
    const downloadLink = document.createElement("a");
    downloadLink.href = "https://eortv.com/eortv_producer_agreement.docx";
    downloadLink.download = "eortv_producer_agreement.docx";
    downloadLink.click();
});