const AWS = require('aws-sdk');
const dynamodb = new AWS.DynamoDB({ region: 'ap-south-1' });


var uid;
var enddatename;
var diffDays;
var mainpasscode;
var device, devicename, devicetype, deviceid;

auth.onAuthStateChanged(function (user) {
    if (user) {
        uid = user.uid;
        db.ref("Users").child(uid).once("value", snap => {
            var name = snap.child("username").val();
            var useremail = snap.child("useremail").val();
            var userphone = snap.child("usernumber").val();
            var pics = snap.child("pics").val();
            if (pics == null || pics == undefined || pics == "null" || pics == "undefined") {
                document.getElementById("imagePreview").style.backgroundImage = `url(assets/userimage.png)`;
                document.getElementById("username").innerHTML = name;
                document.getElementById("usernum").innerHTML = userphone;
                document.getElementById("useremail").innerHTML = useremail;
            }
            else {
                document.getElementById("imagePreview").style.backgroundImage = `url('${pics}')`;
                document.getElementById("username").innerHTML = name;
                document.getElementById("usernum").innerHTML = userphone;
                document.getElementById("useremail").innerHTML = useremail;
            }
        }).then(() => {
            subscriptionPlans(uid);
        }).then(() => {
            favs();
        }).then(() => {
            recents();
        })
    }
    else {
        // window.open("login", "_top");
        // Second HTML file (getPNumber.html)
        var retrievedPNumber = localStorage.getItem('pnumber');

        if (retrievedPNumber) {
            uid = retrievedPNumber;
            db.ref("Users").child(uid).once("value", snap => {
                var name = snap.child("username").val();
                var useremail = snap.child("useremail").val();
                var userphone = snap.child("usernumber").val();
                var pics = snap.child("pics").val();
                if (pics == null || pics == undefined || pics == "null" || pics == "undefined") {
                    document.getElementById("imagePreview").style.backgroundImage = `url(assets/userimage.png)`;
                    document.getElementById("username").innerHTML = name;
                    document.getElementById("usernum").innerHTML = userphone;
                    document.getElementById("useremail").innerHTML = useremail;
                } else {
                    document.getElementById("imagePreview").style.backgroundImage = `url('${pics}')`;
                    document.getElementById("username").innerHTML = name;
                    document.getElementById("usernum").innerHTML = userphone;
                    document.getElementById("useremail").innerHTML = useremail;
                }
            }).then(() => {
                subscriptionPlans(retrievedPNumber);
            }).then(() => {
                favs();
            }).then(() => {
                recents();
            }).catch(error => {
                // Handle any potential errors here
                console.error("Error:", error);
            });
        } else {
            // Handle case where 'pnumber' is not found in localStorage
            console.error("'pnumber' not found in localStorage");
        }
    }
})

async function favs() {
    var fbref = db.ref("Users").child(uid).child("Favourites");
    let promises = []
    fbref.on("child_added", async snap => {
        document.getElementById("nofavs").style.display = "none"
        await db.ref(`Users/${uid}/Favourites/${snap.key}`).once('value', innerSnap => {
            var key1 = innerSnap.child("key1").val();
            var key2 = innerSnap.child("key2").val();
            db.ref(`All Shows/${key1}/${key2}`).once('value', innerSnap => {
                var image = innerSnap.child("appbanner").val();
                var html = document.getElementById("favs").innerHTML;
                document.getElementById("favs").innerHTML = `
<img src="${image}" style="pointer:cursor" onclick="addseries('${key2}','${key1}')" alt="Eortv">
` + html;
            })
        })
    })
}

async function recents() {
    var fbref = db.ref("Users").child(uid).child("Recents");
    let promises = []
    fbref.on("child_added", async snap => {
        document.getElementById("norecents").style.display = "none"
        await db.ref(`Users/${uid}/Recents/${snap.key}`).once('value', innerSnap => {
            var key1 = innerSnap.child("key1").val();
            var key2 = innerSnap.child("key2").val();
            db.ref(`All Shows/${key1}/${key2}`).once('value', innerSnap => {
                var image = innerSnap.child("appbanner").val();
                var html = document.getElementById("recents").innerHTML;
                document.getElementById("recents").innerHTML = `
<img src="${image}" style="pointer:cursor" onclick="addseries('${key2}','${key1}')" alt="Eortv">
` + html;
            })
        })
    })
}

function addseries(movieId, refpath) {
    var myData = {
        'id': movieId,
        'langType': refpath
    };
    localStorage.setItem('originalID', JSON.stringify(myData));
    window.open("originals_details.php", "_top");
}

function subscriptionPlans(uid) {
    const params = {
        TableName: 'SubscribedUsers',
        Key: {
            'subscribers': { S: uid }
        }
    };

    dynamodb.getItem(params, (err, data) => {
        if (err) {
            console.error('Error getting subscription data:', err);

        } else {
            if (data.Item) {
                const subscriptionInfo = AWS.DynamoDB.Converter.unmarshall(data.Item);

                const { startDate, endDate } = subscriptionInfo; // Assuming these fields exist in your DynamoDB table
                const todayDate = new Date(); // Current date

                const startDateFormatted = new Date(startDate);
                const endDateFormatted = new Date(endDate);

                const differenceInTime = endDateFormatted.getTime() - todayDate.getTime();
                const differenceInDays = differenceInTime / (1000 * 3600 * 24);

                if (differenceInDays <= 0) {
                    document.getElementById("ongoingSubscriptions").innerHTML = `<p>You Do Not Have Any Active Subscription Plans <span style="font-family:sfheavy"> :(</span></p>`;
                } else {
                    const text = `${differenceInDays} Days Left For Renewal`;
                    document.getElementById("ongoingSubscriptions").innerHTML = `<p>${text}</p>`;
                }
            } else {
                document.getElementById("ongoingSubscriptions").innerHTML = `<p>You Do Not Have Any Active Subscription Plans <span style="font-family:sfheavy"> :(</span></p>`;
                document.getElementById("activedevices").innerHTML += `
                    <br>
                    <div class="row"> 
                        <button style="margin-top:15%;border-radius:25px;background-color:transparent;border:2px solid green" class="btn thumb" onclick="opensubs()">
                            View Subscription Plans
                        </button>
                    </div>
                `;
            }
        }
    });
}



function dropmenu() {
    document.getElementById("myDropdown").classList.toggle("show");
}
window.onclick = function (event) {
    if (!event.target.matches('.dropbtn')) {
        var dropdowns = document.getElementsByClassName("dropdown-content");
        var i;
        for (i = 0; i < dropdowns.length; i++) {
            var openDropdown = dropdowns[i];
            if (openDropdown.classList.contains('show')) {
                openDropdown.classList.remove('show');
            }
        }
    }
}

function logout() {
    auth.onAuthStateChanged(function (user) {
        if (user) {
            auth.signOut().then(() => {
                window.open("https://eortv.com", "_top")
            });
        }
    })
};


function timeStampWithOnlyDate() {
    var d = new Date();
    date = ("0" + (d.getDate())).slice(-2);
    month = ("0" + (d.getMonth() + 1)).slice(-2);
    year = d.getFullYear();
    return `${date}-${month}-${year}`
}

function changeDateFormat(date) {
    var dateparts = date.split("-");
    var monthPart = dateparts[1];
    var datePart = dateparts[0];
    var yearPart = dateparts[2];
    return `${monthPart}/${datePart}/${yearPart}`;
}

function opensubs() {
    window.open('subscription', '_top');
}

