
async function loadAWSConfig() {
    try {
        const response = await fetch("https://eortv.com/config");
        const awsConfig = await response.json();
        AWS.config.update({
            accessKeyId: awsConfig.accessKeyId,
            secretAccessKey: awsConfig.secretAccessKey,
            region: awsConfig.region
        });
        console.log("AWS Config Loaded Successfully:");
    } catch (error) {
        console.error("Error fetching AWS Config:", error);
    }
}

loadAWSConfig();

const docClient = new AWS.DynamoDB.DocumentClient();

const params = {
    TableName: 'directors',
};

docClient.scan(params, (err, data) => {
    if (err) {
        console.error("Unable to scan the table. Error JSON:", JSON.stringify(err, null, 2));
    } else {
        console.log("Scan succeeded.");
        data.Items.forEach((item, index) => {
            document.getElementById("tbody").innerHTML += `
            <tr>
                <td><img src="${item.directorimg}" style="margin:auto;display:block;border-radius:50px;width:70px;height:70px;padding:0px;"></td>
                <td style="padding:10px;font-size:1vw;font-family:sflight;">${item.directorname}</td>
                <td style="padding:10px;font-size:1vw;font-family:sflight;">${item.directordescription}</td>
                <td style="padding:10px;font-size:1vw;font-family:sflight;">
                    <div id="contact-${index}">
                        <button onclick="handleViewContact('${item.details}', ${index})" style="padding:10px;font-size:1vw;border:none;border-radius:20px;font-family:sflight;color:white;background-color:green;font-weight:600;">View Contact</button>
                    </div>
                    <div id="contact-details-${index}" style="display:none;">
                        ${item.directorcontact} <br>
                        ${item.directorcontactnumber} <br>
                        <a href="${item.directorcontactlinkedin}">Linkedin</a>
                    </div>
                </td>
            </tr>`;
        });
    }
});
let checkUidInterval = setInterval(() => {
    if (typeof uid !== 'undefined') {
        console.log(uid);
        console.log('UID found:', uid);
        clearInterval(checkUidInterval);
    }
}, 100);


async function handleViewContact(details, index) {
    try {
        updateDirectorView(details, uid);
        document.getElementById(`contact-${index}`).style.display = "none";
        document.getElementById(`contact-details-${index}`).style.display = "block";
    } catch (error) {
        console.error("Error handling view contact:", error);
    }
}

function updateDirectorView(details, uid) {
    console.log(details);
    console.log(uid);

    const updateParams = {
        TableName: 'directors',
        Key: {
            details: details
        },
        UpdateExpression: "SET #view = list_append(if_not_exists(#view, :emptyList), :uidList)",
        ExpressionAttributeNames: {
            "#view": "view"
        },
        ExpressionAttributeValues: {
            ":emptyList": [],
            ":uidList": [uid]
        },
        ConditionExpression: "attribute_exists(details)",
        ReturnValues: "UPDATED_NEW"
    };

    docClient.update(updateParams, (err, data) => {
        if (err) {
            console.error("Unable to update directors table. Error JSON:", JSON.stringify(err, null, 2));
        } else {
            console.log("Update succeeded:", JSON.stringify(data, null, 2));
        }
    });
}
