var movieDetails = localStorage['originalID'];
var movieID = JSON.parse(movieDetails).id;
var movieLanguageType = JSON.parse(movieDetails).langType;
var image, des, director, duration, aname, type, trailer, year;
var tcode = 0;

addOriginals()
addtrailernteaser(toggle_video_modal);
addepisodes(toggle_video_modal);
addcast(third);

//Originals
async function addOriginals() {
    let promises = []
    await $.getJSON(`https://eortv.com/OriginalsJson/${movieID}.json`, function (data) {
        $.each(data, function (key, val) {
            if (key == "image") {
                image = val
            } if (key == "des") {
                des = val
            } if (key == "director") {
                director = val
            } if (key == "duration") {
                duration = val
            } if (key == "name") {
                aname = val
            } if (key == "type") {
                type = val
            } if (key == "trailer2") {
                trailer = val
            } if (key == "year") {
                year = val
            }
            document.getElementById("sname").innerHTML = aname
            document.getElementById("poster").src = image
            document.getElementById("director").innerHTML = "A " + director + " Series";
            document.getElementById("movieDuration").innerHTML = "" + duration;
            document.getElementById("movieType").innerHTML = "" + type;
            document.getElementById("movieYear").innerHTML = "" + year;
            document.getElementById("movieDescription").innerHTML = "" + des;
            document.getElementById("loading").style.display = "none"
            document.getElementById("btnlink").innerHTML = `
            <button class="btn js-trigger-video-modal"
            data-id="${trailer}" 
                data-player="www.youtube.com/embed/" 
                style="padding:8px 14px;border-radius:20px;"> Watch Trailer
            </button>`
        })
    })
}

//episodes
async function addepisodes(callback) {
    let promises = []
    await $.getJSON(`https://eortv.com/OriginalsJson/${movieID}MusicEpisodes.json`, function (banners) {
        for (let i = 0; i < banners.length; i++) {
            var eimage = banners[i].image
            var ename = banners[i].name
            var episodeLink = banners[i].link2
            document.getElementById("episodes").innerHTML += `
            <div>
                <a data-id="${episodeLink}" 
                data-player="www.youtube.com/embed/" class="card video-thumb js-trigger-video-modal">
                <div class="thumb" style="background-image: url(${eimage});"></div>
                <article><div><h1>${ename}</h1></div></article>
            </a>
        </div>`;
        }
        callback();
    })
}

//Trailers N Teasers
async function addtrailernteaser(callback) {
    let promises = []
    await $.getJSON(`https://eortv.com/OriginalsJson/${movieID}Trailers.json`, function (banners) {
        for (let i = 0; i < banners.length; i++) {
            var timage = banners[i].image
            var tlink = banners[i].link2
            var tname = banners[i].name
            document.getElementById("trailernteaser").innerHTML += `
            <div>
                <a data-id="${tlink}" 
                data-player="www.youtube.com/embed/" class="card video-thumb js-trigger-video-modal">
                <div class="thumb" style="background-image: url(${timage});"></div>
                <article><div><h1>${tname}</h1></div></article>
                </a>
        </div>`;
        }
        callback()
    })
}

// CAST
async function addcast(callback) {
    await $.getJSON(`https://eortv.com/OriginalsJson/${movieID}Cast.json`, function (banners) {
        for (let i = 0; i < banners.length; i++) {
            var cimage = banners[i].image
            var cname = banners[i].name
            var cname2 = cname.split(/(\s+)/);
            var fname = cname2[0];
            var lname = cname2[2];
            if (cimage == "") {
                cimage = "https://upload.wikimedia.org/wikipedia/commons/thumb/5/50/Black_colour.jpg/1200px-Black_colour.jpg"
            }
            document.getElementById("cast").innerHTML += ` <div>
            <a class="video-thumb">
            <img src="${cimage}" style="display:block;padding:10px !important"alt="cast" />
            <p style="line-height:18px;font-size:15px;" class="castp"> ${fname}<br>${lname}</p>
            </a>
        </div>`
        }
    })
    callback();
}

function toggle_video_modal() {
    $(".js-trigger-video-modal").on("click", function (e) {
        e.preventDefault();
        var id = $(this).attr('data-id');
        var type = $(this).attr('data-player')
        var autoplay = '?autoplay=1';
        var related_no = '&rel=0';
        var src = `https://${type}` + id + autoplay + related_no;
        $('#player').attr('src', src);
        $("body").addClass("show-video-modal noscroll");
    });
    function close_video_modal() {
        event.preventDefault();
        $("body").removeClass("show-video-modal noscroll");
        $("#player").attr('src', '');
    }
    $('body').on('click', '.close-video-modal, .video-modal .overlay', function (event) {
        close_video_modal();
    });
    $('body').keyup(function (e) {
        if (e.keyCode == 27) {
            close_video_modal();
        }
    })
}

function third() {
    $('.responsive3').slick({
        dots: true,
        prevArrow: $('.prev'),
        nextArrow: $('.next'),
        infinite: false,
        speed: 300,
        slidesToShow: 8,
        swipeToSlide: true,
        responsive: [
            {
                breakpoint: 1024,
                settings: {
                    slidesToShow: 3,
                    infinite: true,
                    dots: true,
                    swipeToSlide: true
                }
            },
            {
                breakpoint: 600,
                settings: {
                    slidesToShow: 3,
                    swipeToSlide: true
                }
            },
            {
                breakpoint: 480,
                settings: {
                    slidesToShow: 3,
                    swipeToSlide: true
                }
            }
        ]
    })
}

/*NEW CODES*/

async function clickControl() {
    const noClick = () => {
        return new Promise(resolve => {
            setTimeout(() => resolve($('figcaption').css('z-index', '1')), 1500);
        });
    }
    await noClick();
}

$("figcaption").on("contextmenu mousedown", function (e) {
    switch (e.which) {
        case 1:
            $('figcaption').css('z-index', '0');
            break;
        case 2:
            break;
        case 3:
            return false;
        default:
            break;
    }
    clickControl();
});