
async function loadAWSConfig() {
    try {
        const response = await fetch("https://eortv.com/config");
        const awsConfig = await response.json();
        AWS.config.update({
            accessKeyId: awsConfig.accessKeyId,
            secretAccessKey: awsConfig.secretAccessKey,
            region: awsConfig.region
        });
        console.log("AWS Config Loaded Successfully:");
    } catch (error) {
        console.error("Error fetching AWS Config:", error);
    }
}

loadAWSConfig();

const docClient = new AWS.DynamoDB.DocumentClient();

let checkUserDetail = setInterval(function () {
    if (typeof userdetail !== 'undefined') {
        clearInterval(checkUserDetail);
        console.log(userdetail);
        if (userdetail == "Logged In") {
            var params = {
                TableName: 'careers',
                Key: {
                    details: uid
                }
            };

            docClient.get(params, function (err, data) {
                if (err) {
                    console.error("Unable to read item. Error JSON:", JSON.stringify(err, null, 2));
                } else {
                    if (data.Item) {
                        window.location.href = "https://eortv.com/listings";
                    } else {
                        document.getElementById("loading").style.display = "none";
                    }
                }
            });
        }
        else {
            window.location.href = "https://eortv.com/login";
        }
    }
}, 500);

function submitbtn() {
    var cmail = document.getElementById("cmail").value;
    var cnum = document.getElementById("cnum").value;
    var checkboxt = document.getElementById("checkboxt").checked;

    if (cmail === "") {
        alert("Please Enter A Valid Email ID");
        return;
    }

    var emailPattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,6}$/;
    if (!emailPattern.test(cmail)) {
        alert("Please Enter A Valid Email ID");
        return;
    }

    if (cnum === "") {
        alert("Please Enter A Valid Number");
        return;
    }

    if (!checkboxt) {
        alert("Please Accept Our Terms");
        return;
    }

    var params = {
        TableName: 'careers',
        Item: {
            details: uid,
            number: cnum,
            email: cmail,
            terms: 'accepted'
        }
    };

    docClient.put(params, function (err, data) {
        if (err) {
            console.error("Unable to add item. Error JSON:", JSON.stringify(err, null, 2));
        } else {
            console.log("Added item:", JSON.stringify(data, null, 2));
            window.location.href = "https://eortv.com/listings";
        }
    });
}

if (userdetail == "Logged In") {
    document.getElementById("loading").style.display = "none";
}