
async function loadAWSConfig() {
    try {
        const response = await fetch("https://eortv.com/config");
        const awsConfig = await response.json();
        AWS.config.update({
            accessKeyId: awsConfig.accessKeyId,
            secretAccessKey: awsConfig.secretAccessKey,
            region: awsConfig.region
        });
        console.log("AWS Config Loaded Successfully:");
    } catch (error) {
        console.error("Error fetching AWS Config:", error);
    }
}

loadAWSConfig();

var username;
var usersNumber;
var uid, useractive;
var reff, userdetail;

auth.onAuthStateChanged(function (user) {
    if (user) {
        uid = user.uid;
        console.log(uid);
        userdetail = "Logged In";

        const dynamoDB = new AWS.DynamoDB.DocumentClient();

        // Fetch subscription details from 'SubscribedUsers'
        const params1 = {
            TableName: 'SubscribedUsers',
            Key: {
                subscribers: uid + ""
            },
        };

        dynamoDB.get(params1, (err, data) => {
            if (err) {
                console.error('Error reading item from DynamoDB:', err);
            } else {
                if (data.Item) {
                    const endDateStr = data.Item.enddate;
                    const endDateParts = endDateStr.split('-');
                    const endDate = new Date(endDateParts[2], endDateParts[1] - 1, endDateParts[0]);
                    const currentDate = new Date();
                    const differenceInMillis = endDate - currentDate;
                    const differenceInDays = Math.ceil(differenceInMillis / (1000 * 60 * 60 * 24));
                    if (differenceInDays < 0) {
                        console.log('SUBSCRIPTION DOES NOT EXIST');
                        useractive = "NO";
                    } else {
                        console.log('SUBSCRIPTION EXISTS');
                        useractive = "YES";
                    }
                    console.log('EndDate:', endDateStr);
                    console.log('Difference in days:', differenceInDays);
                } else {
                    console.log('SUBSCRIPTION DOES NOT EXIST');
                    useractive = "NO";
                }
            }
        });

        // Fetch useremail from 'eortv' table
        getUserEmail(uid);

    } else {
        var retrievedPNumber = localStorage.getItem('pnumber');
        if (retrievedPNumber) {
            uid = retrievedPNumber;
            console.log(uid);
            userdetail = "Logged In";

            // Fetch subscription details from 'SubscribedUsers'
            const params1 = {
                TableName: 'SubscribedUsers',
                Key: {
                    subscribers: uid + ""
                },
            };

            dynamoDB.get(params1, (err, data) => {
                if (err) {
                    console.error('Error reading item from DynamoDB:', err);
                } else {
                    if (data.Item) {
                        const endDateStr = data.Item.enddate;
                        const endDateParts = endDateStr.split('-');
                        const endDate = new Date(endDateParts[2], endDateParts[1] - 1, endDateParts[0]);
                        const currentDate = new Date();
                        const differenceInMillis = endDate - currentDate;
                        const differenceInDays = Math.ceil(differenceInMillis / (1000 * 60 * 60 * 24));
                        if (differenceInDays < 0) {
                            console.log('SUBSCRIPTION DOES NOT EXIST');
                            useractive = "NO";
                        } else {
                            console.log('SUBSCRIPTION EXISTS');
                            useractive = "YES";
                        }
                        console.log('EndDate:', endDateStr);
                        console.log('Difference in days:', differenceInDays);
                    } else {
                        console.log('SUBSCRIPTION DOES NOT EXIST');
                        useractive = "NO";
                    }
                }
            });

            // Fetch useremail from 'eortv' table
            getUserEmail(uid);

        } else {
            console.error("'pnumber' not found in localStorage");
            userdetail = "Logged Out";
            useractive = "NO";
        }
    }
});

// Function to get useremail from the 'eortv' table and push to dataLayer
function getUserEmail(uid) {
    const dynamoDB = new AWS.DynamoDB.DocumentClient();
    const params = {
        TableName: 'eortv',
        Key: {
            eortv_media: uid + ""
        },
        ProjectionExpression: "useremail" // Only retrieve the useremail attribute
    };

    dynamoDB.get(params, (err, data) => {
        if (err) {
            console.error('Error reading item from DynamoDB:', err);
        } else {
            if (data.Item && data.Item.useremail) {
                const useremail = data.Item.useremail;
                console.log('User Email:', useremail);
                dataLayer.push({
                    event: "form_submitted",
                    email: useremail
                });
            } else {
                console.log('No email found for the user');
            }
        }
    });
}

function logout() {
    auth.onAuthStateChanged(function (user) {
        if (user) {
            auth.signOut().then(() => {
                window.open("https://eortv.com", "_top");
            });
        } else {
            window.open("https://eortv.com", "_top");
        }
    });
}

function toggleStyle() {
    var button = $(".navbar-toggler");
    var isExpanded = button.attr("aria-expanded");
    if (isExpanded === "true") {
        button.css("top", "25%");
    } else {
        button.css("top", "4%");
        document.getElementById("logostyle").style.marginTop = "15%";
    }
}
