
async function loadAWSConfig() {
    try {
        const response = await fetch("https://eortv.com/config");
        const awsConfig = await response.json();
        AWS.config.update({
            accessKeyId: awsConfig.accessKeyId,
            secretAccessKey: awsConfig.secretAccessKey,
            region: awsConfig.region
        });
        console.log("AWS Config Loaded Successfully:");
    } catch (error) {
        console.error("Error fetching AWS Config:", error);
    }
}

loadAWSConfig();

var username;
var usersNumber;
var uid, useractive, useremailid;
var reff, userdetail;

auth.onAuthStateChanged(function (user) {
    if (user) {
        uid = user.uid;
        console.log(uid);
        userdetail = "Logged In";

        const dynamoDB = new AWS.DynamoDB.DocumentClient();

        const subscriptionParams = {
            TableName: 'SubscribedUsers',
            Key: {
                subscribers: uid + "",
            },
        };

        dynamoDB.get(subscriptionParams, (err, data) => {
            if (err) {
                console.error('Error reading item from DynamoDB:', err);
            } else {
                if (data.Item) {
                    const endDateStr = data.Item.enddate;
                    const endDateParts = endDateStr.split('-');
                    const endDate = new Date(endDateParts[2], endDateParts[1] - 1, endDateParts[0]);
                    const currentDate = new Date();
                    const differenceInMillis = endDate - currentDate;
                    const differenceInDays = Math.ceil(differenceInMillis / (1000 * 60 * 60 * 24));

                    if (differenceInDays < 0) {
                        console.log('SUBSCRIPTION DOES NOT EXIST');
                        useractive = "NO";
                    } else {
                        console.log('SUBSCRIPTION EXISTS');
                        useractive = "YES";
                    }

                    console.log('EndDate:', endDateStr);
                    console.log('Difference in days:', differenceInDays);
                } else {
                    console.log('SUBSCRIPTION DOES NOT EXIST');
                    useractive = "NO";
                }
            }
        });

        // Fetch useremail from eortv table
        const eortvParams = {
            TableName: 'eortv',
            Key: {
                eortv_media: uid + "",
            },
            ProjectionExpression: "useremail" // Corrected key name
        };

        dynamoDB.get(eortvParams, (err, data) => {
            if (err) {
                console.error('Error fetching useremail from eortv table:', err);
            } else {
                if (data.Item && data.Item.useremail) {
                    console.log('User Email:', data.Item.useremail);
                    useremailid = data.Item.useremail;
                } else {
                    console.log('User Email not found for this user.');
                    useremailid = "Not Found";
                }
            }
        });

    } else {
        var retrievedPNumber = localStorage.getItem('pnumber');
        if (retrievedPNumber) {
            uid = retrievedPNumber;
            console.log(uid);
            userdetail = "Logged In";

            const dynamoDB = new AWS.DynamoDB.DocumentClient();
            const subscriptionParams = {
                TableName: 'SubscribedUsers',
                Key: {
                    subscribers: uid + "",
                },
            };

            dynamoDB.get(subscriptionParams, (err, data) => {
                if (err) {
                    console.error('Error reading item from DynamoDB:', err);
                } else {
                    if (data.Item) {
                        const endDateStr = data.Item.enddate;
                        const endDateParts = endDateStr.split('-');
                        const endDate = new Date(endDateParts[2], endDateParts[1] - 1, endDateParts[0]);
                        const currentDate = new Date();
                        const differenceInMillis = endDate - currentDate;
                        const differenceInDays = Math.ceil(differenceInMillis / (1000 * 60 * 60 * 24));

                        if (differenceInDays < 0) {
                            console.log('SUBSCRIPTION DOES NOT EXIST');
                            useractive = "NO";
                        } else {
                            console.log('SUBSCRIPTION EXISTS');
                            useractive = "YES";
                        }

                        console.log('EndDate:', endDateStr);
                        console.log('Difference in days:', differenceInDays);
                    } else {
                        console.log('SUBSCRIPTION DOES NOT EXIST');
                        useractive = "NO";
                    }
                }
            });

            // Fetch useremail from eortv table
            const eortvParams = {
                TableName: 'eortv',
                Key: {
                    eortv_media: uid + "",
                },
                ProjectionExpression: "useremail" // Corrected key name
            };

            dynamoDB.get(eortvParams, (err, data) => {
                if (err) {
                    console.error('Error fetching useremail from eortv table:', err);
                } else {
                    if (data.Item && data.Item.useremail) {
                        console.log('User Email:', data.Item.useremail);
                        useremailid = data.Item.useremail;
                    } else {
                        console.log('User Email not found for this user.');
                        useremailid = "Not Found";
                    }
                }
            });

        } else {
            console.error("'pnumber' not found in localStorage");
            userdetail = "Logged Out";
            useractive = "NO";
        }
    }
});


function logout() {
    auth.onAuthStateChanged(function (user) {
        if (user) {
            auth.signOut().then(() => {
                window.open("https://eortv.com", "_top")
            });
        }
        else {
            window.open("https://eortv.com", "_top")
        }
    })
}

function toggleStyle() {
    var button = $(".navbar-toggler");
    var isExpanded = button.attr("aria-expanded");
    if (isExpanded === "true") {
        button.css("top", "25%");
    } else {
        button.css("top", "4%");
        document.getElementById("logostyle").style.marginTop = "15%";
    }
}