import { DynamoDBClient } from "@aws-sdk/client-dynamodb";
import { UpdateCommand } from "@aws-sdk/lib-dynamodb";

const client = new DynamoDBClient({ region: "ap-south-1" });

export const handler = async (event) => {
    try {
        const { uid, version, softwareversion } = event;

        if (!uid || !version || !softwareversion) {
            throw new Error("Missing required parameters: uid, version, or softwareversion");
        }

        const params = {
            TableName: "eortv",
            Key: { "eortv_media": uid },
            UpdateExpression: "SET #v = :v, #sv = :sv",
            ExpressionAttributeNames: {
                "#v": "version",
                "#sv": "software version"
            },
            ExpressionAttributeValues: {
                ":v": version,
                ":sv": softwareversion
            },
            ReturnValues: "ALL_NEW"
        };

        const response = await client.send(new UpdateCommand(params));
        return { statusCode: 200, body: JSON.stringify(response.Attributes) };

    } catch (error) {
        return { statusCode: 500, body: JSON.stringify({ error: error.message }) };
    }
};
