import { DynamoDBClient } from "@aws-sdk/client-dynamodb";
import { UpdateCommand, GetCommand } from "@aws-sdk/lib-dynamodb";

// Initialize DynamoDB Client
const client = new DynamoDBClient({ region: "ap-south-1" });

export const handler = async (event) => {
    const { v1, v2, v3, v4, v5, v6, v7, v8 } = event;

    // Parse the v8 value (startdate in dd-mm-yyyy format) into a Date object
    const [dd, mm, yyyy] = v8.split('-');
    const startDateObj = new Date(`${yyyy}-${mm}-${dd}`);

    // Format the startdate as dd-mm-yyyy
    const startdate = `${String(startDateObj.getDate()).padStart(2, '0')}-${String(startDateObj.getMonth() + 1).padStart(2, '0')}-${startDateObj.getFullYear()}`;

    // Calculate enddate by adding v5 days to the startDate
    const endDateObj = new Date(startDateObj);
    endDateObj.setDate(startDateObj.getDate() + parseInt(v5, 10));
    const enddd = String(endDateObj.getDate()).padStart(2, '0');
    const endmm = String(endDateObj.getMonth() + 1).padStart(2, '0');
    const endyyyy = endDateObj.getFullYear();
    const enddate = `${enddd}-${endmm}-${endyyyy}`;

    try {
        // Step 1: Check if the record exists
        const checkParams = {
            TableName: "newsubscriptions",
            Key: { details: startdate },
        };

        const item = await client.send(new GetCommand(checkParams));

        // Step 2: Initialize the details key if not present
        if (!item.Item) {
            const initializeParams = {
                TableName: "newsubscriptions",
                Key: { details: startdate },
                UpdateExpression: "SET #details = :empty",
                ExpressionAttributeNames: { "#details": startdate },
                ExpressionAttributeValues: { ":empty": {} },
            };
            await client.send(new UpdateCommand(initializeParams));
        }

        // Step 3: Add or update the subscription data under the unique number
        const updateParams = {
            TableName: "newsubscriptions",
            Key: { details: startdate },
            UpdateExpression: "SET #uniqueNumber = :data REMOVE #empty",
            ExpressionAttributeNames: {
                "#uniqueNumber": v1, // Unique number (e.g., "9003732045")
                "#empty": startdate, // Remove the empty "startdate" key if it exists
            },
            ExpressionAttributeValues: {
                ":data": {
                    amount: v2,
                    currency: v3,
                    payid: v4,
                    emailid: v6,
                    notes: v7,
                    startdate: startdate,
                    enddate: enddate,
                },
            },
        };

        const updateResult = await client.send(new UpdateCommand(updateParams));
        console.log("Update successful:", updateResult);
        return { success: true, message: "Update successful", result: updateResult };

    } catch (error) {
        console.error("Error updating newsubscriptions table:", error);
        return { success: false, error: error.message };
    }
};
