'use strict';

const AWS = require('aws-sdk');
const docClient = new AWS.DynamoDB.DocumentClient();


exports.handler = async (event, context) => {
    const weortv_media = event.weortv_media;
    const wusernumber = event.wusernumber;
    const wusername = event.wusername;
    const wuseremail = event.wuseremail;
    const wdate = event.wdate;
    const wid = event.wid;
    const wmaindevice = event.wmaindevice;
    const wmaindeviceID = event.wmaindeviceID;
    const wsigndevice = event.wsigndevice;
    const wsignMethod = event.wsignMethod;
    const wtags = event.wtags;
    const wnew = event.wnew;
    const wcountrycode = event.wcountrycode;
    const wcountry = event.wcountry;

    const today = new Date();
    const formattedDate = today.getFullYear().toString() +
        String(today.getMonth() + 1).padStart(2, '0') +
        String(today.getDate()).padStart(2, '0');

    const [day, month, year] = wdate.split("-");
    const formattedDate2 = year + month + day;

    const params = {
        TableName: "eortv",
        Item: {
            "eortv_media": weortv_media,
            "date": wdate,
            "country": wcountry,
            "countrycode": wcountrycode ? "+" + wcountrycode : "",
            "id": wid,
            "maindevice": wmaindevice,
            "maindeviceID": wmaindeviceID,
            "signdevice": wsigndevice,
            "signMethod": wsignMethod,
            "tags": wtags,
            "useremail": wuseremail,
            "username": wusername,
            "usernumber": wusernumber
        }
    };

    const params2 = {
        TableName: "PhoneNumbers",
        Item: {
            "numbers": wusernumber,
            "uid": wid
        }
    };

    const userUpdateParams = (tableName) => ({
        TableName: tableName,
        Key: { "details": formattedDate2 + "" },
        UpdateExpression: `SET #media = :data`,
        ExpressionAttributeNames: {
            "#media": weortv_media.toString()
        },
        ExpressionAttributeValues: {
            ":data": {
                "countrycode": wcountrycode ? "+" + wcountrycode : "",
                "country": wcountry,
                "date": wdate,
                "signdevice": wsigndevice,
                "signMethod": wsignMethod,
                "id": wid,
                "useremail": wuseremail,
                "username": wusername,
                "usernumber": wusernumber
            }
        },
        ReturnValues: "UPDATED_NEW"
    });

    async function getItem() {
        try {
            const putOperations = [
                docClient.put(params).promise(),
                docClient.put(params2).promise()
            ];

            if (wnew === "yes") {
                putOperations.push(docClient.update(userUpdateParams("usersnew")).promise());
                putOperations.push(docClient.update(userUpdateParams("users")).promise());
            } else {
                putOperations.push(docClient.update(userUpdateParams("users")).promise());
            }

            const results = await Promise.all(putOperations);
            console.log("Insert Success:", results);
            return { message: "Data inserted successfully", results };
        } catch (err) {
            console.error("Error inserting data:", err);
            return { message: err.message, code: err.code, statusCode: err.statusCode };
        }
    }

    return await getItem();
};