const AWS = require('aws-sdk');
const docClient = new AWS.DynamoDB.DocumentClient();
exports.handler = async (event, context, callback) => {
    const v1 = event.v1;
    const v2 = event.v2;
    const v3 = event.v3;
    const v4 = event.v4;
    const v5 = parseInt(event.v5);
    let stype;

    switch (v5) {
        case 7:
            stype = "1 Week";
            break;
        case 20:
            stype = "1 Month";
            break;
        case 60:
            stype = "2 Month";
            break;
        case 90:
            stype = "3 Month";
            break;
        case 180:
            stype = "6 Month";
            break;
        case 365:
            stype = "12 Month";
            break;
        default:
            stype = "Unknown";
    }

    const phoneParams = {
        TableName: 'PhoneNumbers',
        Key: { numbers: v1 }
    };
    try {
        const phoneData = await docClient.get(phoneParams).promise();
        if (phoneData.Item) {
            const uid = phoneData.Item.uid;
            console.log('uid:', uid);
            const eortvParams = {
                TableName: 'eortv',
                Key: { eortv_media: uid }
            };

            try {
                const eortvData = await docClient.get(eortvParams).promise();
                if (eortvData.Item) {
                    const name = eortvData.Item.username;
                    console.log('name:', name);
                    const mail = eortvData.Item.useremail;
                    console.log('mail:', mail);

                    const today = new Date();
                    const day = String(today.getDate()).padStart(2, '0');
                    const month = String(today.getMonth() + 1).padStart(2, '0');
                    const year = today.getFullYear();
                    const startdate = `${day}-${month}-${year}`;

                    const enddate = new Date();
                    enddate.setDate(today.getDate() + v5);
                    const endDay = String(enddate.getDate()).padStart(2, '0');
                    const endMonth = String(enddate.getMonth() + 1).padStart(2, '0');
                    const endYear = enddate.getFullYear();
                    const enddateString = `${endDay}-${endMonth}-${endYear}`;

                    const params = {
                        TableName: "SubscribedUsers",
                        Key: { subscribers: uid },
                        UpdateExpression: 'SET startdate = :val1, enddate = :val2, #name = :val3, #num = :val4, amount = :val6, currency = :val7, paymentID = :val8, email = :val9, #type = :val10',
                        ExpressionAttributeNames: { "#name": "name", "#num": "number", "#type": "type" },
                        ExpressionAttributeValues: {
                            ':val1': startdate,
                            ':val2': enddateString,
                            ':val3': name,
                            ':val4': v1,
                            ':val6': v2,
                            ':val7': v3,
                            ':val8': v4,
                            ':val9': mail,
                            ':val10': stype
                        }
                    };

                    const data = await docClient.update(params).promise();
                    console.log('data:', data);

                    return data;
                } else {
                    console.error('Item not found in eortv table for key:', uid);
                    return { error: 'Item not found in eortv table' };
                }
            } catch (err) {
                console.error('Error:', err);
                return { error: err };
            }
        } else {
            console.error('Item not found in PhoneNumbers table for key:', v1);
            return { error: 'Item not found in PhoneNumbers table' };
        }
    } catch (err) {
        console.error('Error:', err);
        return { error: err };
    }
}; 