<?php

$result = $_POST['aalink2'];

function rsa_sha1_sign($policy, $private_key_filename)
{
    $signature = "";
    $fp = fopen($private_key_filename, "r");
    $priv_key = fread($fp, 8192);
    fclose($fp);
    $pkeyid = openssl_get_privatekey($priv_key);
    openssl_sign($policy, $signature, $pkeyid);
    openssl_free_key($pkeyid);

    return $signature;
}

function url_safe_base64_encode($value)
{
    $encoded = base64_encode($value);
    return str_replace(
        array('+', '=', '/'),
        array('-', '_', '~'),
        $encoded
    );
}

function create_stream_name($stream, $policy, $signature, $key_pair_id, $expires, $video_path)
{
    $result = $stream;
    $separator = strpos($stream, '?') == FALSE ? '?' : '&';
    if ($expires) {
        $result .= $separator . "Expires=" . $expires . "&Signature=" . $signature . "&Key-Pair-Id=" . $key_pair_id;
    } else {
        $result .= $separator . "Policy=" . $policy . "&Signature=" . $signature . "&Key-Pair-Id=" . $key_pair_id;
    }

    return str_replace('\n', '', $result);
}


function get_canned_policy_stream_name($video_path, $private_key_filename, $key_pair_id, $expires)
{
    $canned_policy = '{"Statement":[{"Resource":"' . $video_path . '","Condition":{"DateLessThan":{"AWS:EpochTime":' . $expires . '}}}]}';
    $signature = rsa_sha1_sign($canned_policy, $private_key_filename);
    $encoded_signature = url_safe_base64_encode($signature);
    $stream_name = create_stream_name($video_path, null, $encoded_signature, $key_pair_id, $expires, $video_path);
    return $stream_name;
}

$private_key_filename = '../test/priv_key.pem';
$key_pair_id = 'K1UBVMWWJY8ZL1';
$video_path = $result;
$expires = time() + 86400;
$canned_policy_stream_name = get_canned_policy_stream_name($video_path, $private_key_filename, $key_pair_id, $expires);

echo $canned_policy_stream_name;
