var ticketstable;
var lastEvaluatedKey = null;

$(window).on("load", function () {
    AWS.config.update({
        accessKeyId: 'AKIA3XSV5XR6YHPGE4DR',
        secretAccessKey: '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',
        region: 'ap-south-1'
    });
    document.getElementById('loader').style.display = "block";

    var dynamodb = new AWS.DynamoDB.DocumentClient();
    var dateDetails = getDateDetails();
    var year = dateDetails.year;
    var month = dateDetails.month;
    var day = dateDetails.day;

    console.log(year + month + day)
    var params = {
        TableName: 'rentals',
        FilterExpression: "begins_with(details, :prefix)",
        ExpressionAttributeValues: {
            ":prefix": `${year}-${month}-${day}`
        },
        ExclusiveStartKey: lastEvaluatedKey
    };


    var total = 0;
    var transformedData = [];

    function fetchData() {
        dynamodb.scan(params, function (err, data) {

            if (err) {
                console.error('Error fetching data from DynamoDB:', err);
                document.getElementById('loader').style.display = "none";
            } else {
                var items = data.Items;

                console.log(items);

                if (items) {
                    items.forEach(function (entry) {

                        var amount = entry.amount || '';
                        var currency = entry.currency || '';
                        var email = entry.email || '';
                        var location = entry.location || '';
                        var name = entry.name || '';
                        var number = entry.number || '';
                        var paidthrough = entry.paidthrough || '';
                        var paymentid = entry.paymentID || '';
                        var startdate = entry.startdate || '';
                        var type = entry.type || '';

                        total = total + 1;
                        transformedData.push([
                            total,
                            type,
                            startdate,
                            name,
                            email,
                            number,
                            paymentid,
                            location,
                            amount,
                            currency,
                            paidthrough
                        ]);
                    });

                }

                // Check if there is more data to load
                if (data.LastEvaluatedKey) {
                    lastEvaluatedKey = data.LastEvaluatedKey; // Update the last evaluated key
                    params.ExclusiveStartKey = lastEvaluatedKey; // Set the start key for the next request
                    fetchData(); // Recursively fetch the next page of data
                } else {
                    // If no more data, initialize the DataTable
                    ticketstable = $('#ticketstable').DataTable({
                        data: transformedData,
                        "dom": '<"top"<"dt-filters"f>>rBt<"dt-bottom"<"dt-information"li><"dt-pagination"p>>',
                        "buttons": [
                            {
                                extend: 'colvis',
                                text: 'Restore Defaults'
                            }
                        ],
                        "columnDefs": [{
                            "targets": 'no-sort',
                            "orderable": false,
                        }],
                        "paging": true,
                        "pageLength": 100,
                        "lengthMenu": [100, 200, 500, 1000],
                        "responsive": true,
                        "colReorder": {
                            realtime: false
                        },
                        "stateSave": false,

                        initComplete: function () {
                            let _container = $(this).parents('.console-panel').find('.get_dt_search');
                            let _bottom_container = $(this).parents('.console-panel').find('.dt-bottom-container');
                            $("#ticketstable_wrapper .dataTables_filter input").appendTo(_container);
                            $("#ticketstable_wrapper  .dt-filters").css("display", "none");
                            $(_container).find("input").attr('placeholder', 'Search From Table');
                            $("#ticketstable_wrapper .dt-bottom").appendTo(_bottom_container);
                            dashboardFilters();
                        }
                    });

                    document.getElementById('loader').style.display = "none";
                    document.getElementById('page_name').innerHTML = total + " <span style='font-size:1rem;color:white;opacity:1;'>Total Daily Rentals On " + day + "/" + month + "/" + year + "</span>";
                }
            }
        });
    }

    fetchData(); // Initial call to fetch data

    function dashboardFilters() {
        $('.filterhead').each(function (i) {
            var select = $('<select multiple class="multiselect"></select>')
                .appendTo($(this).empty())
                .on('change', function () {
                    var selectedValues = $(this).val() || [];
                    if (selectedValues.length > 0) {
                        ticketstable.column(i).search(selectedValues.join('|'), true, false).draw();
                    } else {
                        ticketstable.column(i).search('').draw();
                    }
                });
            var uniqueValues = [];
            transformedData.forEach(function (item) {
                if (!uniqueValues.includes(item[i])) {
                    uniqueValues.push(item[i]);
                    var option = $('<option></option>').text(item[i]);
                    select.append(option);
                }
            });
            $(".multiselect").SumoSelect({ search: true, searchText: 'Enter here.' });
        });
    }
});

// Get Date Details
function getDateDetails() {
    var today = new Date();
    var year = today.getFullYear().toString();
    var month = String(today.getMonth() + 1).padStart(2, '0');
    var day = String(today.getDate()).padStart(2, '0');
    var formattedDate = `${year}-${month}-${day}`;
    $('#datetoday').val(formattedDate);
    return { year, month, day };
}
// Date change event listener
var dateInput = document.getElementById('datetoday');
dateInput.addEventListener('change', datechng);


function datechng() {

    document.getElementById('loader').style.display = "block";

    var chngdate = document.getElementById('datetoday').value;
    var parts = chngdate.split("-");
    var yearnew = parts[0];
    var monthnew = parts[1];
    var daynew = parts[2];

    var prefix = `${yearnew}-${monthnew}-${daynew}`; // or `${yearnew}${monthnew}${daynew}` if your `details` is like that

    var dynamodb = new AWS.DynamoDB.DocumentClient();
    var newData = [];
    var total = 0;

    var params = {
        TableName: 'rentals',
        FilterExpression: "begins_with(details, :prefix)",
        ExpressionAttributeValues: {
            ":prefix": prefix
        }
    };

    // Use scan since begins_with on partition key only works in FilterExpression
    dynamodb.scan(params, function (err, data) {
        if (err) {
            console.error('Error fetching data from DynamoDB:', err);
            document.getElementById("loader").style.display = "none";
        } else {
            const items = data.Items;
            console.log(items);

            if (items && items.length > 0) {
                items.forEach(function (entry) {
                    var amount = entry.amount || '';
                    var currency = entry.currency || '';
                    var email = entry.email || '';
                    var location = entry.location || '';
                    var name = entry.name || '';
                    var number = entry.number || '';
                    var paidthrough = entry.paidthrough || '';
                    var paymentid = entry.paymentID || '';
                    var startdate = entry.startdate || '';
                    var type = entry.type || '';

                    total = total + 1;
                    newData.push([
                        total,
                        type,
                        startdate,
                        name,
                        email,
                        number,
                        paymentid,
                        location,
                        amount,
                        currency,
                        paidthrough
                    ]);
                });

                // Update DataTable
                ticketstable.clear().rows.add(newData).draw();
                $('.filterhead').empty();
                $(".multiselect").empty();

                let _container = $(ticketstable.table().container()).parents('.console-panel').find('.get_dt_search');
                let _bottom_container = $(ticketstable.table().container()).parents('.console-panel').find('.dt-bottom-container');

                $("#ticketstable_wrapper .dataTables_filter input").appendTo(_container);
                $("#ticketstable_wrapper .dt-filters").css("display", "none");
                $(_container).find("input").attr('placeholder', 'Search From Table');
                $("#ticketstable_wrapper .dt-bottom").appendTo(_bottom_container);
                dashboardFilters2(newData);
            } else {
                console.log("No entries found for the selected date.");
                ticketstable.clear().rows.add([]).draw();
            }

            document.getElementById('page_name').innerHTML = total + " <span style='font-size:1rem;color:white;opacity:1;'>Total Daily Rentals On " + daynew + "/" + monthnew + "/" + yearnew + "</span>";
            document.getElementById("loader").style.display = "none";
        }
    });

}


// Update the dashboard filters for the new data
function dashboardFilters2(newData) {
    $('.filterhead').each(function (ii) {
        $(this).find('.multiselect').val(null).trigger('change');
        var select2 = $('<select multiple class="multiselect"></select>').appendTo($(this).empty()).on('change', function () {
            var selectedValues2 = select2.val() || [];
            if (selectedValues2.length > 0) {
                ticketstable.column(ii).search(selectedValues2.join('|'), true, false).draw();
            } else {
                ticketstable.column(ii).search('').draw();
            }
        });
        var uniqueValues2 = [];
        newData.forEach(function (item2) {
            if (!uniqueValues2.includes(item2[ii])) {
                uniqueValues2.push(item2[ii]);
                var option2 = $('<option></option>').text(item2[ii]);
                select2.append(option2);
            }
        });
        select2.SumoSelect({ search: true, searchText: 'Enter here.' });
    });
}
