AWS.config.update({
    accessKeyId: 'AKIA3XSV5XR6YHPGE4DR',
    secretAccessKey: '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',
    region: 'ap-south-1'
});

const ddb = new AWS.DynamoDB();

$(window).on("load", function () {
    document.getElementById('loader').style.display = "block";
    let tryID = 1;

    function getPlanData() {
        const params = {
            TableName: 'subscriptionplans',
            Key: {
                'details': { S: String(tryID) }
            }
        };

        ddb.getItem(params, function (err, data) {
            if (err || !data.Item) {
                tryID++;
                if (tryID < 10) {
                    getPlanData();
                } else {
                    console.log("No plan found.");
                    document.getElementById('loader').style.display = "none";
                }
            } else {
                document.getElementById('loader').style.display = "none";
                renderFields(data.Item);
            }
        });
    }

    getPlanData();

    function renderFields(item) {
        let container = $('#country-pricing-fields');
        const countries = {};
        for (const key in item) {
            if (key.startsWith("actual price ")) {
                const country = key.replace("actual price ", "").trim();
                countries[country] = countries[country] || {};
            }
            if (key.startsWith("currency ")) {
                const country = key.replace("currency ", "").trim();
                countries[country] = countries[country] || {};
                countries[country].currency = item[key].S;
            }
        }

        const allCountryData = { ...countries };

        let html = `
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        NAME OF PLAN: <br> <input type="text" id="planName"><br><br>
                        BACKGROUND IMAGE: <br> <input type="text" id="backgroundImage">
                    </div>
                    <div class="col-md-6">
                        NUMBER OF DAYS: <br> <input type="number" min="1" id="numberOfDays" style="width: 100%;padding: 12px 20px;margin: 8px 0;box-sizing: border-box;">
                        <p id="daysWarning" style="color:red; display:none;">❗ Minimum of 7 days required.</p>
                    </div>
                </div>
        `;

        function renderCountryBlock(country, currency = '') {
            const safeCountryID = country.replace(/[^a-zA-Z0-9]/g, '_');
            return `
                <br><hr><br>
                <h2>${country.toUpperCase()} (${currency})</h2><br>
                <div class="row">
                    <div class="col-md-6">
                        OLD PRICE: <br> <input type="number" min="1" id="oldPrice_${safeCountryID}" style="width: 100%;padding: 12px 20px;margin: 8px 0;box-sizing: border-box;"><br><br>
                    </div>
                    <div class="col-md-6">
                        SALE PRICE: <br> <input type="number" min="1" id="salePrice_${safeCountryID}" style="width: 100%;padding: 12px 20px;margin: 8px 0;box-sizing: border-box;"><br><br>
                    </div>
                </div>
            `;
        }

        ['India', 'International'].forEach(primaryCountry => {
            if (countries[primaryCountry]) {
                html += renderCountryBlock(primaryCountry, countries[primaryCountry].currency || '');
                delete countries[primaryCountry];
            }
        });

        Object.keys(countries).sort().forEach(country => {
            html += renderCountryBlock(country, countries[country].currency || '');
        });

        html += `
            <br><button id="createPlanButton" class="btn btn-primary">CREATE NEW SUBSCRIPTION PLAN</button>
            </div>
            <div id="planPopup" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background-color: rgba(0,0,0,0.8); z-index:1000; color:#fff; text-align:center; padding-top:150px;">
                <h3>DO NOT CLOSE THIS WINDOW. YOUR SUBSCRIPTION PLANS ARE BEING CREATED.</h3>
                <div id="loader" class="spinner-border" style="width: 3rem; height: 3rem;"></div>
            </div>
        `;

        container.html(html);

        $('#createPlanButton').click(function () {
            let allValid = true;
            let planName = $('#planName').val().trim();
            let bgImg = $('#backgroundImage').val().trim();
            let days = $('#numberOfDays').val().trim();

            if (!planName || !bgImg || !days || parseInt(days) <= 0) allValid = false;

            if (parseInt(days) < 7) {
                $('#daysWarning').show();
                $('html, body').animate({ scrollTop: 0 }, 'fast');
                $('#createPlanButton').prop('disabled', false);
                return;
            } else {
                $('#daysWarning').hide();
            }

            for (const country in allCountryData) {
                const safeCountryID = country.replace(/[^a-zA-Z0-9]/g, '_');
                const sale = $(`#salePrice_${safeCountryID}`).val().trim();
                const old = $(`#oldPrice_${safeCountryID}`).val().trim();

                if (!sale || !old || parseFloat(sale) <= 0 || parseFloat(old) <= 0) {
                    allValid = false;
                    break;
                }
            }

            if (!allValid) {
                alert("Please fill all fields correctly. Only positive values allowed.");
                $('#createPlanButton').prop('disabled', false);
                return;
            }

            $('#createPlanButton').prop('disabled', true);
            $('#planPopup').show();

            const allCountries = Object.keys(allCountryData);
            createRazorpayPlans(planName, allCountries, allCountryData, days, bgImg);
        });

        function createRazorpayPlans(basePlanName, allCountries, allCountryData, days, bgImg) {
            let createdCount = 0;
            const responseMap = {};
            const timestamp = String(Date.now());

            allCountries.forEach(country => {
                const safeCountryID = country.replace(/[^a-zA-Z0-9]/g, '_');
                const salePrice = parseFloat($(`#salePrice_${safeCountryID}`).val().trim());
                const oldPrice = parseFloat($(`#oldPrice_${safeCountryID}`).val().trim());
                const currency = allCountryData[country]?.currency || '';
                const amount = salePrice * 100;

                const countryPlanName = `${basePlanName} - ${country}`;

                $.ajax({
                    url: 'createplan.php',
                    type: 'GET',
                    data: {
                        planName: countryPlanName,
                        amount: amount,
                        currency: currency,
                        days: days
                    },
                    dataType: 'json',
                    success: function (response) {
                        const planID = response.receivedData?.id;
                        responseMap[country] = planID || '';
                        createdCount++;

                        if (createdCount === allCountries.length) {
                            const finalPayload = {
                                TableName: 'subscriptionplans',
                                Item: {
                                    'details': { S: timestamp },
                                    'name': { S: basePlanName },
                                    'color': { S: bgImg },
                                    'days': { S: days }
                                }
                            };

                            allCountries.forEach(c => {
                                const safeID = c.replace(/[^a-zA-Z0-9]/g, '_');
                                const sale = $(`#salePrice_${safeID}`).val().trim();
                                const old = $(`#oldPrice_${safeID}`).val().trim();
                                const curr = allCountryData[c]?.currency || '';
                                const planID = responseMap[c];

                                if (old) finalPayload.Item[`actual price ${c}`] = { S: old };
                                if (sale) finalPayload.Item[`sale price ${c}`] = { S: sale };
                                if (curr) finalPayload.Item[`currency ${c}`] = { S: curr };
                                if (planID) finalPayload.Item[`subscriptionID ${c}`] = { S: planID };
                            });

                            ddb.putItem(finalPayload, function (err, data) {
                                if (err) {
                                    console.error("DynamoDB Error:", err);
                                    alert("Plans created but failed to update database.");
                                } else {
                                    alert("All plans created and database updated successfully!");
                                }
                                $('#planPopup').hide();
                            });
                        }
                    },
                    error: function () {
                        alert("Failed to create plan for " + country);
                        $('#planPopup').hide();
                        $('#createPlanButton').prop('disabled', false);
                    }
                });
            });
        }
    }
});
