function setMinDate() {
    const today = new Date();
    const yyyy = today.getFullYear();
    const mm = String(today.getMonth() + 1).padStart(2, '0');
    const dd = String(today.getDate()).padStart(2, '0');
    const minDate = `${yyyy}-${mm}-${dd}`;
    document.getElementById("customEndDate").setAttribute("min", minDate);
}

document.getElementById('typecc').addEventListener('change', function () {
    const selectedType = this.value;
    const durationDiv = document.getElementById('durationDiv');
    const discountFields = document.getElementById('discountFields');

    if (selectedType === "Discount") {
        durationDiv.style.display = "none";
        discountFields.style.display = "block";

        // Make fields required
        document.getElementById('enddatecc').required = true;
        document.getElementById('usagecc').required = true;
        document.getElementById('discountcc').required = true;
        document.getElementById('discountintcc').required = true;

    } else if (selectedType === "Subscription") {
        durationDiv.style.display = "block";
        discountFields.style.display = "none";

        // Remove required attributes
        document.getElementById('enddatecc').required = false;
        document.getElementById('usagecc').required = false;
        document.getElementById('discountcc').required = false;
        document.getElementById('discountintcc').required = false;

        // Clear hidden field values
        document.getElementById('discountcc').value = "";
        document.getElementById('discountintcc').value = "";
    } else {
        durationDiv.style.display = "none";
        discountFields.style.display = "none";
    }
});

document.getElementById('enddatecc').addEventListener('change', function () {
    const selected = this.value;
    const customInput = document.getElementById('customEndDate');

    if (selected === "custom") {
        setMinDate();
        customInput.style.display = "block";
        customInput.required = true;
    } else {
        customInput.style.display = "none";
        customInput.required = false;
        customInput.value = "";
    }
});


function addcc() {
    const code = document.getElementById('codecc').value.trim();
    const type = document.getElementById('typecc').value;
    const endDateType = document.getElementById('enddatecc').value;
    const customEndDate = document.getElementById('customEndDate').value.trim();
    const usage = document.getElementById('usagecc').value;

    const duration = document.getElementById('durationcc').value.trim();
    const discount = document.getElementById('discountcc').value.trim();
    const discountInt = document.getElementById('discountintcc').value.trim();

    // Common validations
    if (!code) {
        alert("⚠️ Please enter the CODE.");
        return;
    }
    if (!type) {
        alert("⚠️ Please select a TYPE.");
        return;
    }
    if (!endDateType) {
        alert("⚠️ Please select an END DATE.");
        return;
    }
    if (endDateType === "custom") {
        if (!customEndDate) {
            alert("⚠️ Please pick a custom END DATE.");
            return;
        }


    }
    if (!usage) {
        alert("⚠️ Please select a USAGE type.");
        return;
    }

    const endDateValue = endDateType === "custom" ? convertYYYYMMDDtoDDMMYYYY(customEndDate) : endDateType;

    if (type === "Subscription") {
        if (!duration) {
            alert("⚠️ Please enter the DURATION for Subscription.");
            return;
        }

        const dataToSave = {
            duration: duration,
            enddate: endDateValue,
            type: type,
            usage: usage
        };

        const updates = {};
        updates[code] = dataToSave;

        db.ref("Codes").update(updates)
            .then(() => {
                alert(`✅ Subscription code "${code}" saved successfully!`);
            })
            .catch(error => {
                console.error("Error saving subscription code:", error);
                alert("❌ Failed to save subscription code.");
            });

    } else if (type === "Discount") {
        if (!discount) {
            alert("⚠️ Please enter the DISCOUNT Indian (%).");
            return;
        }
        if (!discountInt) {
            alert("⚠️ Please enter the DISCOUNT International (%).");
            return;
        }

        const discountNum = Number(discount);
        const discountIntNum = Number(discountInt);

        if (
            isNaN(discountNum) || discountNum < 1 || discountNum > 100 ||
            isNaN(discountIntNum) || discountIntNum < 1 || discountIntNum > 100
        ) {
            alert("⚠️ Discount values must be numbers between 1 and 100.");
            return;
        }

        const dataToSave = {
            discountamount: discountNum.toString(),
            discountamountdollars: discountIntNum.toString(),
            discounttype: "%",
            enddate: endDateValue,
            type: type,
            usage: usage
        };

        const updates = {};
        updates[code] = dataToSave;

        db.ref("Codes").update(updates)
            .then(() => {
                alert(`✅ Discount code "${code}" saved successfully!`);
            })
            .catch(error => {
                console.error("Error saving discount code:", error);
                alert("❌ Failed to save discount code.");
            });

    } else {
        alert("⚠️ Invalid TYPE selected.");
        return;
    }
}
function convertYYYYMMDDtoDDMMYYYY(dateStr) {
    const parts = dateStr.split('-');
    if (parts.length !== 3) return dateStr;
    return `${parts[2]}-${parts[1]}-${parts[0]}`;
}
