AWS.config.update({
    accessKeyId: 'AKIA3XSV5XR6YHPGE4DR',
    secretAccessKey: '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',
    region: 'ap-south-1'
});

const ddb = new AWS.DynamoDB();

let countryData = [];

$(window).on("load", function () {
    populateCountryDropdown();
});

async function populateCountryDropdown() {
    const response = await fetch("https://eortv.com/json/Countries.json");
    countryData = await response.json();

    const select = document.getElementById("country-select");

    countryData.forEach(({ name, code, currency }) => {
        const cleanName = name.replace(/\s*\(\+\d+\)/, "");
        const option = document.createElement("option");
        option.value = code;
        option.setAttribute("data-name", cleanName);
        option.setAttribute("data-currency", currency);
        option.textContent = `${cleanName} - ${currency}`;
        select.appendChild(option);
    });

    select.addEventListener("change", () => {
        const selectedOption = select.options[select.selectedIndex];
        const selectedCountry = selectedOption.getAttribute("data-name").trim();
        const selectedCurrency = selectedOption.getAttribute("data-currency");
        if ([...existingSubscriptionCountries].some(c => c.trim().toLowerCase() === selectedCountry.toLowerCase())) {
            alert(`⚠️ ${selectedCountry} already has subscription plans added.`);
            const container = document.getElementById("plans-container");
            container.innerHTML = "";
            return;
        }
        loadSubscriptionPlans(selectedCountry, selectedCurrency);
    });
}

function loadSubscriptionPlans(selectedCountry, selectedCurrency) {
    const params = {
        TableName: "subscriptionplans"
    };

    ddb.scan(params, function (err, data) {
        const container = document.getElementById("plans-container");
        container.innerHTML = "";

        if (err) {
            console.error("Error loading plans:", err);
            container.innerHTML = `<p style="color:red;">Error loading plans</p>`;
            return;
        }

        data.Items.forEach((item, index) => {
            const planName = item.name?.S || "Unnamed Plan";
            const days = item.days?.S || "N/A";

            // Actual and sale price keys
            const actualKey = `actual price ${selectedCountry}`;
            const saleKey = `sale price ${selectedCountry}`;

            // Check if keys exist
            const itemKeys = Object.keys(item);
            const alreadyAdded = itemKeys.includes(actualKey) && itemKeys.includes(saleKey);

            let html = `
                <div style="margin-bottom: 20px; border: 1px solid #ccc; padding: 15px; border-radius: 10px;">
                    <h4>${planName} - Duration: <strong>${days} days</strong></h4><br> 
            `;

            if (alreadyAdded) {
                html += `<p style="color: green;"><strong>${selectedCountry}</strong> pricing already exists.</p>`;
            } else {
                html += `<div style="display:flex;gap:50px">
                 <div>   <label>Actual Price (${selectedCurrency}):</label><br>
                    <input type="number" id="actual_${index}" placeholder="Enter actual price"><br><br>

                     </div>  <div>   <label>Sale Price (${selectedCurrency}):</label><br>
                    <input type="number" id="sale_${index}" placeholder="Enter sale price"><br>
                    </div>  </div>
                `;
            }

            html += `</div>`;
            container.insertAdjacentHTML("beforeend", html);
        });
    });
}


listCountriesWithSubscriptionIDs();

let existingSubscriptionCountries = new Set();

function listCountriesWithSubscriptionIDs() {
    const params = {
        TableName: "subscriptionplans"
    };

    ddb.scan(params, function (err, data) {
        if (err) {
            console.error("❌ Error scanning table:", err);
            return;
        }

        data.Items.forEach(item => {
            const keys = Object.keys(item);
            keys.forEach(key => {
                if (key.startsWith("subscriptionID ")) {
                    const country = key.replace("subscriptionID ", "");
                    existingSubscriptionCountries.add(country);
                }
            });
        });

        console.log("🌍 Countries with existing subscription IDs:");
        console.log(Array.from(existingSubscriptionCountries).join(", "));
    });
}


document.getElementById("add-country-btn").addEventListener("click", async function () {
    const button = this;
    const statusMsg = document.getElementById("add-status");
    const countrySelect = document.getElementById("country-select");
    const selectedCode = countrySelect.value;
    const selectedCountryName = countrySelect.options[countrySelect.selectedIndex].text.split(" - ")[0].trim();
    const selectedCurrency = countrySelect.options[countrySelect.selectedIndex].getAttribute("data-currency");

    if (!selectedCountryName || !selectedCurrency) {
        alert("Please select a valid country.");
        return;
    }

    // Check for empty fields
    const planCount = document.querySelectorAll("[id^='actual_']").length;
    for (let i = 0; i < planCount; i++) {
        const actual = document.getElementById(`actual_${i}`)?.value;
        const sale = document.getElementById(`sale_${i}`)?.value;
        if (!actual || !sale) {
            alert(`Please fill all price fields for plan #${i + 1}`);
            return;
        }
    }

    if (!confirm(`Are you sure you want to add ${selectedCountryName}?`)) return;

    // Disable button
    button.disabled = true;
    statusMsg.style.display = "block";

    try {
        const plans = await new Promise((resolve, reject) => {
            ddb.scan({ TableName: "subscriptionplans" }, (err, data) => {
                if (err) reject(err);
                else resolve(data.Items);
            });
        });

        let createdCount = 0;

        plans.forEach((item, i) => {
            const planName = item.name?.S;
            const planDays = item.days?.S;
            const partitionKey = item.details?.S;

            const actualVal = document.getElementById(`actual_${i}`)?.value.trim();
            const saleVal = document.getElementById(`sale_${i}`)?.value.trim();

            if (!planName || !planDays || !partitionKey || !actualVal || !saleVal) {
                createdCount++;
                if (createdCount === plans.length) finalize();
                return;
            }

            // Check if already added
            const actualKey = `actual price ${selectedCountryName}`;
            const saleKey = `sale price ${selectedCountryName}`;
            const subKey = `subscriptionID ${selectedCountryName}`;
            const currencyKey = `currency ${selectedCountryName}`;
            if (
                item[actualKey] || item[saleKey] || item[subKey] || item[currencyKey]
            ) {
                createdCount++;
                if (createdCount === plans.length) finalize();
                return;
            }

            const fullPlanName = `${planName} - ${selectedCountryName}`;
            const razorAmount = parseInt(saleVal) * 100;

            $.ajax({
                url: 'createplan.php',
                type: 'GET',
                data: {
                    planName: fullPlanName,
                    amount: razorAmount,
                    currency: selectedCurrency,
                    days: planDays
                },
                dataType: 'json',
                success: function (response) {
                    const planID = response.receivedData?.id;
                    if (!planID) {
                        alert(`Razorpay failed to return plan ID for ${fullPlanName}`);
                        createdCount++;
                        if (createdCount === plans.length) finalize();
                        return;
                    }

                    const updateParams = {
                        TableName: "subscriptionplans",
                        Key: {
                            details: { S: partitionKey }
                        },
                        UpdateExpression: "SET #ap = :ap, #sp = :sp, #sid = :sid, #cur = :cur",
                        ExpressionAttributeNames: {
                            "#ap": actualKey,
                            "#sp": saleKey,
                            "#sid": subKey,
                            "#cur": currencyKey
                        },
                        ExpressionAttributeValues: {
                            ":ap": { S: actualVal },
                            ":sp": { S: saleVal },
                            ":sid": { S: planID },
                            ":cur": { S: selectedCurrency }
                        }
                    };

                    ddb.updateItem(updateParams, function (err, data) {
                        if (err) {
                            console.error("❌ DynamoDB Update Error:", err);
                        }
                        createdCount++;
                        if (createdCount === plans.length) finalize();
                    });
                },
                error: function () {
                    alert(`❌ Failed to create Razorpay plan for ${fullPlanName}`);
                    createdCount++;
                    if (createdCount === plans.length) finalize();
                }
            });
        });

        function finalize() {
            alert(`✅ All plans processed for ${selectedCountryName}`);
            loadSubscriptionPlans(selectedCountryName, selectedCurrency); // Refresh UI
            button.disabled = false;
            statusMsg.style.display = "none";
        }

    } catch (err) {
        console.error(err);
        alert("❌ Unexpected error during plan creation or DB update.");
        button.disabled = false;
        statusMsg.style.display = "none";
    }
});
