$(window).on("load", function () {
    var ticketstable;
    var tableData = [];
    db.ref("Form").once("value", function (snapshot) {
        snapshot.forEach(function (childSnapshot) {
            var item = childSnapshot.val();
            var rowData = [
                item.date,
                item.name,
                item.surname,
                item.email,
                item.number,
                item.message,
                '<button onclick="deletes(\'' + item.details + '\')">DEL</button>'
            ];
            tableData.push(rowData);
            console.log(rowData)
        });

        // Create DataTable with the fetched data
        var ticketstable = $('#ticketstable').DataTable({
            data: tableData,
            "dom": '<"top"<"dt-filters"f>>rBt<"dt-bottom"<"dt-information"li><"dt-pagination"p>>',
            "buttons": [
                {
                    extend: 'colvis',
                    text: 'Restore Defaults'
                }
            ],
            "columnDefs": [{
                "targets": 'no-sort',
                "orderable": false,
            }],
            "responsive": true,
            "colReorder": {
                realtime: false
            },
            "stateSave": false,
            initComplete: function () {
                let _container = $(this).parents('.console-panel').find('.get_dt_search')
                let _bottom_container = $(this).parents('.console-panel').find('.dt-bottom-container')
                $("#ticketstable_wrapper .dataTables_filter input").appendTo(_container);
                $("#ticketstable_wrapper .dt-filters").css("display", "none");
                $(_container).find("input").attr('placeholder', 'Search From Table');
                $("#ticketstable_wrapper .dt-bottom").appendTo(_bottom_container);
                dashboardFilters();
            }
        });

        // Define the dashboardFilters function
        function dashboardFilters() {
            $('.filterhead').each(function (i) {
                var select = $('<select multiple class="multiselect"></select>')
                    .appendTo($(this).empty())
                    .on('change', function () {
                        var selectedValues = $(this).val() || [];
                        if (selectedValues.length > 0) {
                            ticketstable.column(i).search(selectedValues.join('|'), true, false).draw();
                        } else {
                            ticketstable.column(i).search('').draw();
                        }
                    });
                var uniqueValues = [];
                tableData.forEach(function (row) {
                    if (!uniqueValues.includes(row[i])) {
                        uniqueValues.push(row[i]);
                        var option = $('<option></option>').text(row[i]);
                        select.append(option);
                    }
                });
                $(".multiselect").SumoSelect({ search: true, searchText: 'Enter here.' });
            });
        }
    });


});


function deletes(deletecode) {
    const documentClient = new AWS.DynamoDB.DocumentClient();
    const params = {
        TableName: 'accounts',
        Key: {
            details: deletecode
        }
    };

    const confirmationMessage = "Are you sure you want to delete " + deletecode + "?";
    if (confirm(confirmationMessage)) {
        documentClient.delete(params, (err, data) => {
            if (err) {
                alert('Error deleting item from DynamoDB:', err);
            } else {
                alert("Item deleted successfully");
                location.reload()
            }
        });
    }
} 