var ticketstable;
var normalDate;
var currentYear = new Date().getFullYear();
var yearDropdown = document.getElementById("datetoday");

for (var year = 2021; year <= currentYear; year++) {
    var option = document.createElement("option");
    option.value = year;
    option.text = year;
    yearDropdown.add(option);
}
document.getElementById("datetoday").value = currentYear;

// Get current year for default dropdown value
function getCurrentDate() {
    const currentDate = new Date();
    const year = currentDate.getFullYear();
    normalDate = `${year}`;
    return year;
}
const formattedDate = getCurrentDate();

// Add an event listener for the year dropdown change
document.getElementById("datetoday").addEventListener("change", function () {
    document.getElementById('loader').style.display = "block";

    var selectedYear = this.value; // Get the selected year from the dropdown
    loadTableData({ year: selectedYear }); // Reload the table with the selected year
});

// Modify the getYearDetails() function to use the selected year
function getYearDetails() {
    var selectedYear = $('#datetoday').val(); // Get the selected year from the dropdown
    return { year: selectedYear }; // Return the selected year
}

// Update the window load event to reflect the new changes
$(window).on("load", function () {
    AWS.config.update({
        accessKeyId: 'AKIA3XSV5XR6YHPGE4DR',
        secretAccessKey: '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',
        region: 'ap-south-1'
    });
    document.getElementById('loader').style.display = "block";
    loadTableData(getYearDetails());
});

function getYearDetails() {
    var today = new Date();
    var year = today.getFullYear().toString();
    $('#datetoday').val(year);
    return { year };
}

function loadTableData({ year }) {
    var dynamodb = new AWS.DynamoDB.DocumentClient();
    var total = 0;
    var transformedData = [];

    // Loop through each month of the year (1 to 12)
    for (let month = 1; month <= 12; month++) {
        let monthStr = String(month).padStart(2, '0'); // Ensure month is two digits (e.g., 01, 02)

        // Loop through each day of the month (1 to 31)
        for (let day = 1; day <= 31; day++) {
            let dayStr = String(day).padStart(2, '0'); // Ensure day is two digits (e.g., 01, 02)
            var params = {
                TableName: 'users',
                Key: {
                    details: year + monthStr + dayStr // Construct the key as YYYY-MM-DD
                }
            };

            var fetchData = function (lastEvaluatedKey) {
                if (lastEvaluatedKey) {
                    params.ExclusiveStartKey = lastEvaluatedKey; // Set the ExclusiveStartKey if present
                }

                dynamodb.get(params, function (err, data) {
                    if (err) {
                        console.error('Error fetching data from DynamoDB:', err);
                    } else {
                        var items = data.Item;
                        if (items) {
                            Object.keys(items).forEach(function (key) {
                                if (items && items[key]) {
                                    var entry = items[key];
                                    var date = entry.date || '';
                                    var id = entry.id || '';
                                    var signdevice = entry.signdevice || '';
                                    var signmethod = entry.signMethod || '';
                                    var username = entry.username || '';
                                    var usernumber = entry.usernumber || 'NA'; var countrycode = entry.countrycode || '';
                                    var useremail = entry.useremail || 'NA';

                                    if (date && useremail && usernumber) {
                                        total += 1;
                                        transformedData.push([
                                            total,
                                            date,
                                            signdevice,
                                            signmethod,
                                            username,
                                            useremail, countrycode,
                                            usernumber,
                                            id
                                        ]);
                                    }
                                }
                            });
                        }

                        // If there's more data, continue fetching using the LastEvaluatedKey
                        if (data.LastEvaluatedKey) {
                            fetchData(data.LastEvaluatedKey);
                        } else {
                            // After the loop finishes, initialize or refresh the table with the accumulated data
                            if (month === 12 && day === 31) { // After the last month and last day
                                initializeDataTable(transformedData, total, year);
                            }
                        }
                    }
                });
            };

            // Start fetching data for each day
            fetchData();
        }
    }
}

function initializeDataTable(transformedData, total, month, year) {
    if (ticketstable) {
        ticketstable.clear();
        ticketstable.rows.add(transformedData);
        ticketstable.draw();
        document.getElementById('loader').style.display = "none";
        var monthName = new Date(year, parseInt(month) - 1).toLocaleString('default', { month: 'long' });

        document.getElementById('page_name').innerHTML = total + " <span style='font-size:1rem;color:white;opacity:1;'>Total Monthly Logins On " + monthName + " - " + year + "</span>";

    } else {
        ticketstable = $('#ticketstable').DataTable({
            data: transformedData,
            "dom": '<"top"<"dt-filters"f>>rBt<"dt-bottom"<"dt-information"li><"dt-pagination"p>>',
            "buttons": [
                {
                    extend: 'colvis',
                    text: 'Restore Defaults'
                }
            ],
            "columnDefs": [{
                "targets": 'no-sort',
                "orderable": false,
            }],
            "paging": true,
            "pageLength": 100,
            "lengthMenu": [100, 200, 500, 1000],
            "responsive": true,
            "colReorder": {
                realtime: false
            },
            "stateSave": false,

            initComplete: function () {
                let _container = $(this).parents('.console-panel').find('.get_dt_search');
                let _bottom_container = $(this).parents('.console-panel').find('.dt-bottom-container');
                $("#ticketstable_wrapper .dataTables_filter input").appendTo(_container);
                $("#ticketstable_wrapper  .dt-filters").css("display", "none");
                $(_container).find("input").attr('placeholder', 'Search From Table');
                $("#ticketstable_wrapper  .dt-bottom").appendTo(_bottom_container);
                dashboardFilters(transformedData);
            }
        });
        document.getElementById('loader').style.display = "none";
        var monthName = new Date(year, parseInt(month) - 1).toLocaleString('default', { month: 'long' });

        document.getElementById('page_name').innerHTML = total + " <span style='font-size:1rem;color:white;opacity:1;'>Total Monthly Logins On " + monthName + " - " + year + "</span>";

        function dashboardFilters() {
            $('.filterhead').each(function (i) {
                var select = $('<select multiple class="multiselect"></select>')
                    .appendTo($(this).empty())
                    .on('change', function () {
                        var selectedValues = $(this).val() || [];
                        if (selectedValues.length > 0) {
                            ticketstable.column(i).search(selectedValues.join('|'), true, false).draw();
                        } else {
                            ticketstable.column(i).search('').draw();
                        }
                    });
                var uniqueValues = [];
                transformedData.forEach(function (item) {
                    if (!uniqueValues.includes(item[i])) {
                        uniqueValues.push(item[i]);
                        var option = $('<option></option>').text(item[i]);
                        select.append(option);
                    }
                });
                $(".multiselect").SumoSelect({ search: true, searchText: 'Enter here.' });
            });
        }
    }
}