<?php
$apiKey = 'rzp_live_vDj7NgqnSKimz4';
$apiSecret = '8U5wQwAGhbOWDZJnoKlKhzno';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $response = [
        'success' => false,
        'message' => 'Data not received correctly',
        'receivedData' => []
    ];

    if (isset($_GET['planName']) && isset($_GET['amount']) && isset($_GET['currency']) && isset($_GET['days'])) {
        $planName = $_GET['planName'];
        $amount = $_GET['amount'];
        $currency = $_GET['currency'];
        $days = intval($_GET['days']);

        error_log("Received planName: $planName, amount: $amount, currency: $currency, days: $days");

        // Razorpay period/interval config based on days
        $period = 'daily';
        $interval = $days;

        $data = array(
            'period' => $period,
            'interval' => $interval,
            'item' => array(
                'name' => $planName,
                'amount' => $amount,
                'currency' => $currency
            )
        );

        error_log("Prepared data: " . json_encode($data));

        $ch = curl_init('https://api.razorpay.com/v1/plans');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
        curl_setopt($ch, CURLOPT_USERPWD, $apiKey . ':' . $apiSecret);

        $responseFromAPI = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if (!$responseFromAPI) {
            die('Error in cURL request: ' . curl_error($ch));
        }

        error_log("HTTP Code: $httpCode");
        error_log("Response: " . $responseFromAPI);

        if ($httpCode == 200 || $httpCode == 201) {
            $response['success'] = true;
            $response['message'] = 'Plan created successfully';
            $response['receivedData'] = json_decode($responseFromAPI, true);
        } else {
            $response['message'] = 'Failed to create plan. HTTP Code: ' . $httpCode;
            $response['receivedData'] = json_decode($responseFromAPI, true);
        }

        curl_close($ch);
    }

    header('Content-Type: application/json');
    echo json_encode($response);
} else {
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => 'Invalid request method'
    ]);
}
?>
