<?php
// Read data from Bengali.json
$bhojpuriData = file_get_contents('../json/Bengali Movies.json');
$bhojpuriArray = json_decode($bhojpuriData, true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $jsonArray = $bhojpuriArray;

    // Process submitted table data
    foreach ($_POST['table_data'] as $rowData) {
        $image = trim($rowData['image']);
        $link = trim($rowData['link']);
        $name = trim($rowData['name']);
        if ($image !== '' || $link !== '' || $name !== '') {
            $movieData = array(
                "image" => $image,
                "link" => $link,
                "name" => $name
            );
            array_push($jsonArray, $movieData);
        }
    }

    $jsonContent = json_encode($jsonArray, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    $jsonFilePath = 'abc.json';
    file_put_contents($jsonFilePath, $jsonContent);
    echo "JSON file 'abc.json' created and saved successfully.";
}

if (isset($_GET['delete_index'])) {
    $deleteIndex = intval($_GET['delete_index']);
    if ($deleteIndex >= 0 && $deleteIndex < count($bhojpuriArray)) {
        array_splice($bhojpuriArray, $deleteIndex, 1);
        $jsonContent = json_encode($bhojpuriArray, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
        file_put_contents('../json/Bengali Movies.json', $jsonContent);
        echo '<script>alert("Deleted Successfully");</script>';
        echo '<script>window.location.href = "https://eortv.com/admin2/youtube_bengali";</script>';

    }
}
?>

<!DOCTYPE html>
<html lang='en'>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Eortv | Youtube Bengali</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="" />
    <meta name="keywords" content="" />
    <link rel="shortcut icon" href="images/icon.ico">

    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.6.3/css/all.css"
        integrity="sha384-UHRtZLI+pbxtHCWp1t77Bi1L4ZtiqrqD80Kn4Z8NTSRyMA2Fd33n5dQ8lWUE00s/" crossorigin="anonymous">
    <link rel="stylesheet" href="css/bootstrap.min.css" />
    <link rel="stylesheet" href="css/grid_stack.min.css" />
    <link rel="stylesheet" href="js/plugins/jquery_confirm/jquery_confirm.css">
    <link rel="stylesheet" href="js/plugins/colorpicker/bootstrap-colorpicker-plus.min.css">
    <link rel="stylesheet" href="js/plugins/scrollbar/jquery.mCustomScrollbar.min.css">
    <link rel="stylesheet" href="js/plugins/datepicker/datepicker.css">

    <link rel="stylesheet" href="js/plugins/datatable/style.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/colvis/1.1.2/css/dataTables.colVis.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery.sumoselect/3.0.2/sumoselect.min.css" />

    <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet"
        integrity="sha384-wvfXpqpZZVQGK6TAh5PVlGOfQNHSoD2xbE+QkPxCAFlNEevoEH3Sl0sibVcOQVnN" crossorigin="anonymous">
    <link rel="stylesheet" type="text/css" href="css/dripicon.css" />
    <link rel="stylesheet" type="text/css" href="css/style.css" />
    <link rel="stylesheet" type="text/css" href="css/responsive.css" />
    <style>
        /* Modal Styling */
        .modal2,
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0, 0, 0, 0.5);
            transition: opacity 0.3s ease;
        }

        .modal-content2,
        .modal-content {
            background-color: #fefefe;
            margin: 6% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 30%;
            transition: transform 0.3s ease;
            position: relative;
            font-size: 15px;
        }

        .close2,
        .close {
            color: #aaa;
            position: absolute;
            top: 10px;
            right: 10px;
            font-size: 40px !important;
            font-weight: bold;
            cursor: pointer;
        }

        .close2:hover,
        .close2:focus,
        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }

        .btn:hover {
            color: rgb(238, 238, 238)
        }

        input[type="text"] {
            width: 100%;
            padding: 12px 20px;
            margin: 8px 0;
            box-sizing: border-box;
        }

        .btn2,
        .btn {
            padding: 5px 10px;
            background-color: #19468E;
            color: white;
            border: none;
            cursor: pointer;
            margin-top: 10px;
        }


        .btn-save {
            float: right;
        }


        .button-container {
            float: right;
            padding-top: 15px;
        }


        .button-container .btn {
            display: inline-block;
            width: 100px;
        }

        #loader {
            display: none;
        }
    </style>
</head>

<body class="theme-body">
    <div class="theme-wrapper">
        <header>
            <div class="header-left">
                <div class="logo" style="min-width: 0px !important;">
                    <img style="width:50px" id="logo_img" src="images/logo.png" alt="">
                </div>
                <div class="sidemenu-opener"><a href="#" title=""><i class="icon dripicons-align-left"></i></a></div>
                <div class="custom-header-links">
                           <ul class="nav">
                        <li class="nav-item dropdown">
                            <a href="logins.html" title="" class="nav-link">Logins</a>
                        </li>
                        <li class="nav-item dropdown">
                            <a href="users.html" title="" class="nav-link">New Users</a>
                        </li>
                        <li class="nav-item dropdown">
                            <a href="emails.html" title="" class="nav-link">Email ID & Phone Numbers</a>
                        </li>
                        <li class="nav-item dropdown">
                            <a href="subscription.html" title="" class="nav-link">Subscriptions</a>
                        </li>
                        <li class="nav-item dropdown">
                            <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">Pricing</a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="indianplans.html"> Indian Plans </a></li>
                                <li><a class="dropdown-item" href="internationalplans.html"> International Plans</a>
                                </li>
                                <li><a class="dropdown-item" href="iosplans.html"> iOS Plans</a>
                                </li>
                            </ul>
                        </li>
                        <li class="nav-item dropdown">
                            <a href="eortok.html" title="" class="nav-link">Eortok</a>
                        </li>
                        <li class="nav-item dropdown">
                            <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">YouTube Content</a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="youtube_bengali.php"> Bengali Youtube</a></li>
                                <li><a class="dropdown-item" href="youtube_bhojpuri.php"> Bhojpuri Youtube</a></li>
                                <li><a class="dropdown-item" href="youtube_blackwhite.php"> Black & White Youtube</a>
                                </li>
                                <li><a class="dropdown-item" href="youtube_english.php"> English Youtube</a></li>
                                <li><a class="dropdown-item" href="youtube_gujarati.php"> Gujarati Youtube</a></li>
                                <li><a class="dropdown-item" href="youtube_hindi.php"> Hindi Youtube</a></li>
                                <li><a class="dropdown-item" href="youtube_horror.php"> Horror Youtube</a></li>
                                <li><a class="dropdown-item" href="youtube_kannada.php"> Kannada Youtube</a></li>
                                <li><a class="dropdown-item" href="youtube_lgbtq.php"> LGBTQ Youtube</a></li>
                                <li><a class="dropdown-item" href="youtube_malayalam.php"> Malayalam Youtube</a></li>
                                <li><a class="dropdown-item" href="youtube_marathi.php"> Marathi Youtube</a></li>
                                <li><a class="dropdown-item" href="youtube_punjabi.php"> Punjabi Youtube</a></li>
                                <li><a class="dropdown-item" href="youtube_tamil.php"> Tamil Youtube</a></li>
                                <li><a class="dropdown-item" href="youtube_telugu.php"> Telugu Youtube</a></li>
                                <li><a class="dropdown-item" href="youtube_tourism.php"> Tourism Youtube</a></li>
                            </ul>
                        </li>
                        <li class="nav-item dropdown">
                            <a href="banners.php" title="" class="nav-link">App Banners</a>
                        </li>
                        <li class="nav-item dropdown">
                            <a href="top10.php" title="" class="nav-link">Top 10 Banners</a>
                        </li>
                         <li class="nav-item dropdown">
                            <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">Careers</a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="jobs.html"> Resumes </a></li>
                                <li><a class="dropdown-item" href="writers.html"> Script Writers</a></li>
                                <li><a class="dropdown-item" href="producers.html"> Producers</a></li> 
                                <li><a class="dropdown-item" href="directors.html"> Directors</a></li>
                            </ul>
                        </li> <li class="nav-item dropdown">
                        <a href="rentals.html" title="" class="nav-link">Rentals</a>
                    </li> <li class="nav-item dropdown">
                            <a href="coupons.html" title="" class="nav-link">Coupon Codes</a>
                        </li>
                    </ul>
                </div>
            </div>
        </header>
        <div class="theme-content">
            <aside class="console-sidemenu" id="sidemenu">
                <nav>
                    <div class="user logged-in">
                        <a class="login-user" href="#" title=""><img src="images/img1.jpg" alt="" /></a>
                        <div class="user-detail">
                            <strong>Hello There!</strong>
                            <i>admin@eortv.com</i>
                        </div>
                    </div>
                            <ul class="console-menu">
                        <li><a href="logins.html" title=""><i class="fa fa-user-circle"></i><span>Logins</span></a>
                        </li>
                        <li class="sidebar-header"><span></span></li>
                        <li><a href="users.html" title=""><i class="fa fa-users"></i><span>New Users</span></a>
                        </li>
                        <li class="sidebar-header"><span></span></li>
                        <li><a href="emails.html" title=""><i class="fa fa-envelope"></i><span>Email ID & Phone
                                    Numbers</span></a>
                        </li>
                        <li class="sidebar-header"><span></span></li>
                        <li><a href="subscription.html" title=""><i
                                    class="fa fa-money"></i><span>Subscription</span></a>
                        </li>
                        <li class="sidebar-header"><span></span></li>
                        <li> <a href="#" title=""> <i class="fa fa-inr"></i> <span> Pricing</span></a>
                            <ul>
                                <li> <a class="get_pn" href="indianplans.html" title="">
                                        <span>Indian Plans</span></a> </li>
                                <li> <a class="get_pn" href="internationalplans.html" title="">
                                        <span>International Plans</span></a>
                                </li>
                                <li> <a class="get_pn" href="iosplans.html" title="">
                                        <span>iOS Plans</span></a>
                                </li>
                            </ul>
                        </li>
                        <li class="sidebar-header"><span></span></li>
                        <li><a href="eortok.html" title=""><i class="fa fa-video"></i><span>Eortok</span></a>
                        </li>
                        <li class="sidebar-header"><span></span></li>
                        <li> <a href="#" title=""> <i class="fa fa-youtube"></i> <span>Youtube Content</span></a>
                            <ul>
                                <li> <a class="get_pn" href="youtube_bengali.php" title="">
                                        <span>Bengali Youtube</span></a> </li>
                                <li> <a class="get_pn" href="youtube_bhojpuri.php" title="">
                                        <span>Bhojpuri Youtube</span></a>
                                </li>
                                <li> <a class="get_pn" href="youtube_blackwhite.php" title="">
                                        <span>Black & White Youtube</span></a>
                                </li>
                                <li> <a class="get_pn" href="youtube_english.php" title="">
                                        <span>English Youtube</span></a>
                                </li>
                                <li> <a class="get_pn" href="youtube_gujarati.php" title="">
                                        <span>Gujarati Youtube</span></a>
                                </li>
                                <li> <a class="get_pn" href="youtube_hindi.php" title="">
                                        <span>Hindi Youtube</span></a>
                                </li>
                                <li> <a class="get_pn" href="youtube_horror.php" title="">
                                        <span>Horror Youtube</span></a>
                                </li>
                                <li> <a class="get_pn" href="youtube_kannada.php" title="">
                                        <span>Kannada Youtube</span></a>
                                </li>
                                <li> <a class="get_pn" href="youtube_lgbtq.php" title="">
                                        <span>LGBTQ Youtube</span></a>
                                </li>
                                <li> <a class="get_pn" href="youtube_malayalam.php" title="">
                                        <span>Malayalam Youtube</span></a>
                                </li>
                                <li> <a class="get_pn" href="youtube_marathi.php" title="">
                                        <span>Marathi Youtube</span></a>
                                </li>
                                <li> <a class="get_pn" href="youtube_punjabi.php" title="">
                                        <span>Punjabi Youtube</span></a>
                                </li>
                                <li> <a class="get_pn" href="youtube_tamil.php" title="">
                                        <span>Tamil Youtube</span></a>
                                </li>
                                <li> <a class="get_pn" href="youtube_telugu.php" title="">
                                        <span>Telugu Youtube</span></a>
                                </li>
                                <li> <a class="get_pn" href="youtube_tourism.php" title="">
                                        <span>Tourism Youtube</span></a>
                                </li>
                            </ul>
                        </li>
                          <li class="sidebar-header"><span></span></li>
                        <li><a href="banners.php" title=""><i class="fa fa-photo"></i><span>App Banners</span></a>
                        </li>
                        <li class="sidebar-header"><span></span></li>
                        <li><a href="top10.php" title=""><i class="fa fa-file"></i><span>Top 10 Banners</span></a>
                        </li>
                        <li class="sidebar-header"><span></span></li>
                        <li> 
                            <a href="#" title=""> <i class="fa fa-folder"></i> <span>Careers</span></a>
                            <ul> 
                                <li> <a class="get_pn" href="jobs.html" title="">
                                        <span>Resumes</span></a>
                                </li>
                                <li> <a class="get_pn" href="writers.html" title="">
                                        <span>Script Writers</span></a>
                                </li>
                                <li> <a class="get_pn" href="producers.html" title="">
                                        <span> Producers</span></a>
                                </li>
                                <li> <a class="get_pn" href="directors.html" title="">
                                        <span> Directors</span></a>
                                </li>
                            </ul>
                        </li>

                         <li class="sidebar-header"><span></span></li>
                        <li><a href="rentals.html" title=""><i class="fa fa-video"></i><span>Rentals</span></a>
                        </li> <li class="sidebar-header"><span></span></li>
                        <li><a href="coupons.html" title=""><i class="fa fa-ticket"></i><span>Coupon Codes</span></a>
                        </li>
                        <li class="sidebar-header"><span></span></li>
                        <li><a href="login.html" style="cursor: pointer;" title="">
                                <i class="icon dripicons-exit"></i>
                                <span>Logout</span>
                            </a>
                        </li>
                    </ul>
                </nav>
            </aside>

            <div class="content-area">
                <div id="toparea">
                    <div class="page-level-filteration">

                    </div>
                </div>
                <div class="" style="position: relative;">
                    <div class="grid-stack-item" data-gs-x="0" data-gs-y="5" data-gs-width="12" data-gs-height="23"
                        data-gs-min-height="7" data-gs-min-width="10">
                        <div class="console-panel grid-stack-item-content">
                            <div class="console-panel-header wrap">
                                <div class="cph-left">
                                    <h5>Youtube Bengali</h5>
                                    <span>List Of All Youtube Bengali & Their Details</span>
                                </div>
                                <div class="cph-right wrap">
                                    <div class="col">

                                    </div>
                                    <div class="get_dt_search"></div>
                                </div>
                                <div></div>
                            </div>
                            <div id="loader" style="width:200px; ;margin: auto;">
                                <img src="images/loader.gif" style="width:200px;display: block;margin: auto;" alt="">
                            </div>
                            <div class="console-panel-body no-padding">
                                <div class="table-container">
                                    <table class="table table-striped datatable console-table " id="ticketstable">
                                        <thead class="sorticon-pos">
                                            <tr id="abbab">
                                                <th>Image</th>
                                                <th>Name</th>
                                                <th>Link</th>
                                                <th>Delete</th>
                                            </tr>
                                        </thead>
                                        <tbody id="tableBody">
                                    <?php foreach ($bhojpuriArray as $index => $movie): ?>
                                        <tr>
                                            <td><img src="<?= $movie['image'] ?>" width="100"></td>
                                            <td>
                                                <?= $movie['name'] ?>
                                            </td>
                                            <td>
                                                <?= $movie['link'] ?>
                                            </td>
                                            <td><a style="color:blue" href="?delete_index=<?= $index ?>"
                                                    onclick="return confirm('Are you sure you want to delete this movie?')">Delete</a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="console-footer">
                                <div class="dt-bottom-container"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://www.gstatic.com/firebasejs/8.3.2/firebase-app.js"></script>
    <script src="https://www.gstatic.com/firebasejs/8.3.2/firebase-database.js"></script>
    <script src="https://www.gstatic.com/firebasejs/8.3.2/firebase-auth.js"></script>

    <script>
        var firebaseConfig = {
            apiKey: "AIzaSyAVhtTVb6wzel-zq50yfnvuP0KnThFCgbc",
            authDomain: "eor-tv.firebaseapp.com",
            databaseURL: "https://eor-tv.firebaseio.com",
            projectId: "eor-tv",
            storageBucket: "eor-tv.appspot.com",
            messagingSenderId: "878008717406",
            appId: "1:878008717406:web:a8856a77c8aa5fb915a4cf",
            measurementId: "G-V2MSXJMMN8"
        };
        firebase.initializeApp(firebaseConfig);
        const auth = firebase.auth();
        const db = firebase.database();
        var user;
    </script>

    <script src="js/jquerymain_jquerytouch_jquerycookies.js"></script>
    <script src="js/plugins/loader/loadingoverlay.min.js"></script>
    <script src="js/plugins/scrollbar/jquery.mCustomScrollbar.concat.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="js/bootstrap_popper.min.js"></script>
    <script>var _tooltip = jQuery.fn.tooltip;</script>
    <script src="js/jquery_ui.min.js"></script>
    <script>jQuery.fn.tooltip = _tooltip;</script>
    <script src="js/grid_stack_pack.min.js"></script>
    <script src="js/plugins/colorpicker/bootstrap-colorpicker-plus.min.js"></script>
    <script src="js/plugins/jquery_confirm/jquery_confirm.js"></script>
    <script src="js/plugins/toaster/jquery.toaster.js"></script>
    <script src="https://www.amcharts.com/lib/4/core.js"></script>
    <script src="https://www.amcharts.com/lib/4/charts.js"></script>
    <script src="https://www.amcharts.com/lib/4/themes/animated.js"></script>
    <script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/colreorder/1.5.1/js/dataTables.colReorder.min.js"></script>
    <script src="https://cdn.datatables.net/colvis/1.1.2/js/dataTables.colVis.min.js"></script>
    <script src="js/plugins/sparkline/jquery.sparkline.min.js"></script>
    <script src="js/plugins/chartjs/Chart.bundle.min.js"></script>
    <script src="js/plugins/datepicker/datepicker.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.sumoselect/3.0.2/jquery.sumoselect.min.js"></script>
    <script src="js/script.js"></script>

    <script src="https://sdk.amazonaws.com/js/aws-sdk-2.921.0.min.js"></script>
 
</body>

</html>