<?php
$razorpayWebhookSecret = '!Eortv@1234';

$webhookPayload = file_get_contents('php://input');
$headers = getallheaders();
$receivedSignature = $headers['X-Razorpay-Signature'];

$expectedSignature = hash_hmac('sha256', $webhookPayload, $razorpayWebhookSecret);

if ($receivedSignature === $expectedSignature) {
    $event = json_decode($webhookPayload, true);

    if ($event['event'] === 'payment.authorized') {
        $filename1 = "body.json";
        $filename2 = "header.json";
        file_put_contents("$filename1", $webhookPayload);
        file_put_contents("$filename2", json_encode($headers));

        $json_url = 'https://eortv.com/admin2/webhooks/body.json';
        $json_data = file_get_contents($json_url);
        $data = json_decode($json_data);
        
        // Extracting payment details
        $contact = $data->payload->payment->entity->contact;
        $email = $data->payload->payment->entity->email;
        $amount = $data->payload->payment->entity->amount;
        $currency = $data->payload->payment->entity->currency;
        $description = $data->payload->payment->entity->description;
        $id = $data->payload->payment->entity->id;
        $notes = isset($data->payload->payment->entity->notes) ? $data->payload->payment->entity->notes : null;

        // Check if notes are present
        if ($notes) {
            // Process notes here
            file_put_contents('notes.json', json_encode($notes));  // Save notes to file if present
        } else {
            // Handle case where notes are not present
            file_put_contents('notes.json', 'No notes found');
        }

        // You can continue with the rest of your processing here...
        $modified_amount = substr($amount, 0, -2);

        $days = '';
        if ($modified_amount == 135 || $modified_amount == 99 || $modified_amount == 5) {
            $days = '7';
        } elseif ($modified_amount == 195 || $modified_amount == 9) {
            $days = '20';
        } elseif ($modified_amount == 333 || $modified_amount == 10) {
            $days = '60';
        } elseif ($modified_amount == 450 || $modified_amount == 12) {
            $days = '90';
        } elseif ($modified_amount == 720 || $modified_amount == 18) {
            $days = '180';
        } elseif ($modified_amount == 999 || $modified_amount == 27) {
            $days = '365';
        }

        // Get today's date in dd-mm-yyyy format
        $todayDate = date('d-m-Y');

        if (substr($contact, 0, 3) === '+91') {
            $contact = substr($contact, 3);
            $api_url = "https://rjuzqfz25a.execute-api.ap-south-1.amazonaws.com/default/subdatanew?"
                . "v1=" . urlencode($contact)
                . "&v2=" . urlencode($modified_amount)
                . "&v3=" . urlencode($currency)
                . "&v4=" . urlencode($id)
                . "&v5=" . urlencode($days)
                . "&v6=" . urlencode($email)
                . "&v7=" . urlencode($description)
                . "&v8=" . urlencode($todayDate);

            $response = file_get_contents($api_url);
        }
        http_response_code(200);
    } else {
        http_response_code(400);
    }
} else {
    http_response_code(403);
}
?>
