var ticketstable;

$(window).on("load", function () {
    AWS.config.update({
        accessKeyId: 'AKIA3XSV5XR6YHPGE4DR',
        secretAccessKey: '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',
        region: 'ap-south-1'
    });
    document.getElementById('loader').style.display = "block";

    loadTableData(getMonthDetails());
});

function getMonthDetails() {
    var today = new Date();
    var year = today.getFullYear().toString();
    var month = String(today.getMonth() + 1).padStart(2, '0');
    var formattedMonth = `${year}-${month}`;
    $('#datetoday').val(formattedMonth);
    return { year, month };
}

function loadTableData({ year, month }) {
    var dynamodb = new AWS.DynamoDB.DocumentClient();
    var total = 0;
    var transformedData = [];
    var dayPromises = [];
    for (let day = 1; day <= 31; day++) {
        let dayStr = String(day).padStart(2, '0');
        let detailsKey = `${dayStr}-${month}-${year}`;

        let dayPromise = new Promise((resolve, reject) => {
            var params = {
                TableName: 'newsubscriptions',
                Key: {
                    details: detailsKey
                }
            };

            dynamodb.get(params, function (err, data) {
                if (err) {
                    console.error(`Error fetching data for ${detailsKey}:`, err);
                    reject(err);
                } else {
                    resolve({ day: dayStr, data: data.Item || null }); // Resolve with data
                }
            });
        });

        dayPromises.push(dayPromise); // Add the promise to the array
    }

    // Process all promises
    Promise.all(dayPromises)
        .then(results => {
            results.forEach(({ day, data }) => {
                if (data) {
                    Object.keys(data).forEach(function (key) {
                        if (key === 'details') return;
                        var entry = data[key];
                        var startdate = entry.startdate || '';
                        var enddate = entry.enddate || '';
                        var paymentID = entry.payid || '';
                        var email = entry.emailid || '';
                        var amount = parseFloat(entry.amount) || 0;
                        var notes = entry.notes || '';
                        var currency = entry.currency || '';

                        if (currency === "INR") {
                            var location = 'Indian';
                        }
                        else {
                            var location = 'International';
                        }

                        if (paymentID === "iOS") {
                            var platform = 'iOS';
                        }
                        else {
                            var platform = 'Android';
                        }

                        var city = entry.city || '';
                        var statez = entry.statez || '';
                        var country = entry.country || '';

                        if (notes === '' || notes === 'nan') {
                            notes = 'First';
                        }

                        var planname = '';
                        if ([99, 135, 5].includes(amount)) {
                            planname = '1 Week';
                        } else if ([195, 9].includes(amount)) {
                            planname = '1 Month';
                        } else if ([333, 10].includes(amount)) {
                            planname = '2 Month';
                        } else if ([450, 12].includes(amount)) {
                            planname = '3 Month';
                        } else if ([720, 18].includes(amount)) {
                            planname = '6 Month';
                        } else if ([999, 27].includes(amount)) {
                            planname = '12 Month';
                        }

                        total += 1;

                        transformedData.push([
                            total,
                            startdate,
                            enddate,
                            paymentID,
                            planname,
                            key,
                            email,
                            amount,
                            currency,
                            notes, platform, location, city, statez, country
                        ]);
                    });
                }
            });

            // Initialize the DataTable with aggregated data
            initializeDataTable(transformedData, total, month, year);
        })
        .catch(error => {
            console.error('Error processing day-wise data:', error);
            document.getElementById('loader').style.display = "none";
        });
}





function initializeDataTable(transformedData, total, month, year) {
    if (ticketstable) {
        ticketstable.clear();
        ticketstable.rows.add(transformedData);
        ticketstable.draw();
        document.getElementById('loader').style.display = "none";
        var monthName = new Date(year, parseInt(month) - 1).toLocaleString('default', { month: 'long' });

        document.getElementById('page_name').innerHTML = total + " <span style='font-size:1rem;color:white;opacity:1;'>Total Monthly Subscriptions On " + monthName + " - " + year + "</span>";

    } else {
        ticketstable = $('#ticketstable').DataTable({
            data: transformedData,
            "dom": '<"top"<"dt-filters"f>>rBt<"dt-bottom"<"dt-information"li><"dt-pagination"p>>',
            "buttons": [
                {
                    extend: 'colvis',
                    text: 'Restore Defaults'
                }
            ],
            "columnDefs": [{
                "targets": 'no-sort',
                "orderable": false,
            }],
            "paging": true,
            "pageLength": 100,
            "lengthMenu": [100, 200, 500, 1000],
            "responsive": true,
            "colReorder": {
                realtime: false
            },
            "stateSave": false,

            initComplete: function () {
                let _container = $(this).parents('.console-panel').find('.get_dt_search');
                let _bottom_container = $(this).parents('.console-panel').find('.dt-bottom-container');
                $("#ticketstable_wrapper .dataTables_filter input").appendTo(_container);
                $("#ticketstable_wrapper  .dt-filters").css("display", "none");
                $(_container).find("input").attr('placeholder', 'Search From Table');
                $("#ticketstable_wrapper  .dt-bottom").appendTo(_bottom_container);
                dashboardFilters(transformedData);
            }
        });
        document.getElementById('loader').style.display = "none";
        var monthName = new Date(year, parseInt(month) - 1).toLocaleString('default', { month: 'long' });

        document.getElementById('page_name').innerHTML = total + " <span style='font-size:1rem;color:white;opacity:1;'>Total Monthly Subscriptions On " + monthName + " - " + year + "</span>";

        function dashboardFilters() {
            $('.filterhead').each(function (i) {
                var select = $('<select multiple class="multiselect"></select>')
                    .appendTo($(this).empty())
                    .on('change', function () {
                        var selectedValues = $(this).val() || [];
                        if (selectedValues.length > 0) {
                            ticketstable.column(i).search(selectedValues.join('|'), true, false).draw();
                        } else {
                            ticketstable.column(i).search('').draw();
                        }
                    });
                var uniqueValues = [];
                transformedData.forEach(function (item) {
                    if (!uniqueValues.includes(item[i])) {
                        uniqueValues.push(item[i]);
                        var option = $('<option></option>').text(item[i]);
                        select.append(option);
                    }
                });
                $(".multiselect").SumoSelect({ search: true, searchText: 'Enter here.' });
            });
        }
    }
}

var dateInput = document.getElementById('datetoday');
dateInput.addEventListener('change', function () {
    var selectedMonth = dateInput.value; // Format: YYYY-MM
    var parts = selectedMonth.split("-");
    var year = parts[0];
    var month = parts[1];
    document.getElementById('loader').style.display = "block";
    loadTableData({ year, month });
});


