$(window).on("load", function () {
    document.getElementById('loader').style.display = "block";

    // Fetch data from Firebase Realtime Database under 'Codes'
    db.ref('Codes').once('value', snapshot => {
        const data = snapshot.val();
        let subscriptioncount = 0;
        let transformedData = [];

        // Iterate through the 'Codes' data and transform it for the DataTable
        for (const key in data) {
            if (data.hasOwnProperty(key)) {
                const item = data[key];
                const duration = item.duration ? `${item.duration} Days` : '-';
                const discount = item.discountamount
                    ? item.discounttype === '%'
                        ? `${item.discountamount} ${item.discounttype}`
                        : `${item.discountamount} INR`
                    : '-';
                const discountInternational = item.discountamountdollars
                    ? item.discounttype === '%'
                        ? `${item.discountamountdollars} ${item.discounttype}`
                        : `${item.discountamountdollars} Dollars`
                    : '-';

                subscriptioncount++;
                transformedData.push([
                    subscriptioncount,
                    key,  // You can display the 'key' from Firebase as the identifier
                    item.type || '-',  // Using item.type as per your original logic
                    duration,
                    item.enddate || '-',  // Displaying item.enddate
                    item.usage || '-',  // Displaying item.usage
                    discount,
                    discountInternational,
                    `<button class="delete-btn" data-key="${key}">Delete</button>`
                ]);
            }
        }

        // Initialize DataTable with transformed data
        ticketstable = $('#ticketstable').DataTable({
            data: transformedData,
            "dom": '<"top"<"dt-filters"f>>rBt<"dt-bottom"<"dt-information"li><"dt-pagination"p>>',
            "buttons": [
                {
                    extend: 'colvis',
                    text: 'Restore Defaults'
                }
            ],
            "columnDefs": [{
                "targets": 'no-sort',
                "orderable": false,
            }],
            "responsive": true,
            "paging": true,
            "pageLength": 100,
            "lengthMenu": [100, 200, 500, 1000],
            "colReorder": {
                realtime: false
            },
            "stateSave": false,
            initComplete: function () {
                let _container = $(this).parents('.console-panel').find('.get_dt_search');
                let _bottom_container = $(this).parents('.console-panel').find('.dt-bottom-container');
                $("#ticketstable_wrapper .dataTables_filter input").appendTo(_container);
                $("#ticketstable_wrapper  .dt-filters").css("display", "none");
                $(_container).find("input").attr('placeholder', 'Search From Table');
                $("#ticketstable_wrapper  .dt-bottom").appendTo(_bottom_container);
                dashboardFilters();
            }
        });

        document.getElementById('loader').style.display = "none";
        document.getElementById('page_name').innerHTML = subscriptioncount + " Total Coupon Codes";

        // Function to handle filters in DataTable
        function dashboardFilters() {
            $('.filterhead').each(function (i) {
                var select = $('<select multiple class="multiselect"></select>')
                    .appendTo($(this).empty())
                    .on('change', function () {
                        var selectedValues = $(this).val() || [];
                        if (selectedValues.length > 0) {
                            ticketstable.column(i).search(selectedValues.join('|'), true, false).draw();
                        } else {
                            ticketstable.column(i).search('').draw();
                        }
                    });
                var uniqueValues = [];
                transformedData.forEach(function (item) {
                    if (!uniqueValues.includes(item[i])) {
                        uniqueValues.push(item[i]);
                        var option = $('<option></option>').text(item[i]);
                        select.append(option);
                    }
                });
                $(".multiselect").SumoSelect({ search: true, searchText: 'Enter here.' });
            });
        }

        $('#ticketstable').on('click', '.delete-btn', function () {
            var key = $(this).data('key');
            var row = $(this).closest('tr');

            if (confirm("Are you sure you want to delete this entry?")) {
                db.ref('Codes/' + key).remove()
                    .then(function () {
                        console.log('Entry successfully deleted from Firebase');
                        ticketstable.row(row).remove().draw();
                        alert("Entry Deleted Successfully");
                        window.location.reload();

                    })
                    .catch(function (error) {
                        console.error('Error deleting entry from Firebase:', error);
                    });
            }
        });
    });
});
