<?php
// Read data from Black & White.json
$bhojpuriData = file_get_contents('../../json/Black & White.json');
$bhojpuriArray = json_decode($bhojpuriData, true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $jsonArray = $bhojpuriArray;

    // Process submitted table data
    foreach ($_POST['table_data'] as $rowData) {
        $image = trim($rowData['image']);
        $link = trim($rowData['link']);
        $name = trim($rowData['name']);
        if ($image !== '' || $link !== '' || $name !== '') {
            $movieData = array(
                "image" => $image,
                "link" => $link,
                "name" => $name
            );
            array_push($jsonArray, $movieData);
        }
    }

    $jsonContent = json_encode($jsonArray, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    $jsonFilePath = 'abc.json';
    file_put_contents($jsonFilePath, $jsonContent);
    echo "JSON file 'abc.json' created and saved successfully.";
}

if (isset($_GET['delete_index'])) {
    $deleteIndex = intval($_GET['delete_index']);
    if ($deleteIndex >= 0 && $deleteIndex < count($bhojpuriArray)) {
        array_splice($bhojpuriArray, $deleteIndex, 1);
        $jsonContent = json_encode($bhojpuriArray, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
        file_put_contents('../../json/Black & White.json', $jsonContent);
        echo '<script>alert("Deleted Successfully");</script>';
        echo '<script>window.location.href = "https://eortv.com/admin/youtube/blackandwhite";</script>';

    }
}
?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EORTV</title>
    <link rel="shortcut icon" href="../images/icon.ico">
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.11.0/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="../css/nindex.css">
    <script src="https://www.gstatic.com/firebasejs/6.1.1/firebase-app.js"></script>
    <script src="https://www.gstatic.com/firebasejs/6.0.4/firebase-database.js"></script>
    <script src="https://www.gstatic.com/firebasejs/6.1.0/firebase-auth.js"></script>

    <style>
        button {
            width: 200px;
            margin-bottom: 20px;
            margin: auto;
            padding: 10px;
            margin-bottom: 20px;
            border-radius: 20px;
        }
    </style>
</head>

<body>
    <div class="d-flex flex-column flex-lg-row h-lg-full bg-surface-secondary">
        <nav class="navbar show navbar-vertical h-lg-screen navbar-expand-lg px-0 py-3 navbar-light bg-white border-bottom border-bottom-lg-0 border-end-lg"
            id="navbarVertical">
            <div class="container-fluid">
                <button class="navbar-toggler ms-n2" type="button" onclick="showmenu()">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <a class="navbar-brand py-lg-2 mb-lg-5 px-lg-6 me-0" href="#">
                    <img src="https://eortv.com/assets/logo.gif" alt="...">
                </a>
                <div class="collapse navbar-collapse" id="sidebarCollapse">
                    <ul class="navbar-nav">
                        <li class="nav-item">
                            <a class="nav-link" href="../daily.html">
                                <i class="bi bi-bar-chart"></i> Reports
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="../contacts.html">
                                <i class="bi bi-envelope"></i> Email ID & Phone Numbers
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="../users.html">
                                <i class="bi bi-people"></i> Users
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="../stores.html">
                                <i class="bi bi-search"></i> Find User
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="../subscriptions/codes.html">
                                <i class="bi bi-ticket-perforated"></i> Coupon Codes
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="../subscriptions/active.html">
                                <i class="bi bi-cash-stack"></i> Active Subscription
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="../subscriptions/list2.html">
                                <i class="bi bi-clipboard-data"></i> Subscriptions Data
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="../subscriptions/list.html">
                                <i class="bi bi-card-list"></i> Subscriptions List
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="../subscriptions/rental.html">
                                <i class="bi bi-currency-exchange"></i> Rental
                            </a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="../subscriptions/price.html">
                                <i class="bi bi-currency-dollar"></i> Subscription Pricing
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="../subscriptions/activation.html">
                                <i class="bi bi-activity"></i> Subscription Activation
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="../mode.html">
                                <i class="bi bi-explicit"></i> Series Ori/Fam Mode
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="../series.html">
                                <i class="bi bi-gear-fill"></i> Series Management
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="../mostwatched.html">
                                <i class="bi bi-heart"></i> Most Watched
                            </a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="../top.html">
                                <i class="bi bi-emoji-heart-eyes"></i> Top 6 Series
                            </a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="../banners.html">
                                <i class="bi bi-easel"></i> App Banners
                            </a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="../originals.html">
                                <i class="bi bi-trello"></i> Original Banners
                            </a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" onclick="showentriesub()" href="#">
                                <i class="bi bi-bookmarks"></i> Youtube Content
                                &emsp14;&emsp14;&emsp14;&emsp14;
                                <i class="bi-caret-down-fill"></i>
                            </a>
                            <div class="links" style="padding-left:45px" id="subentries">
                                <a class="nav-link" href="../youtube/bengali.php">- Bengali </a>
                                <a class="nav-link" href="../youtube/bhojpuri.php">- Bhojpuri </a>
                                <a class="nav-link" href="../youtube/blackandwhite.php">- Black & White </a>
                                <a class="nav-link" href="../youtube/english.php">- English </a>
                                <a class="nav-link" href="../youtube/gujarati.php">- Gujarati </a>
                                <a class="nav-link" href="../youtube/hindi.php">- Hindi </a>
                                <a class="nav-link" href="../youtube/horror.php">- Horror </a>
                                <a class="nav-link" href="../youtube/kannada.php">- Kannada </a>
                                <a class="nav-link" href="../youtube/lgbtq.php">- LGBTQ </a>
                                <a class="nav-link" href="../youtube/malayalam.php">- Malayalam </a>
                                <a class="nav-link" href="../youtube/marathi.php">- Marathi </a>
                                <a class="nav-link" href="../youtube/punjabi.php">- Punjabi </a>
                                <a class="nav-link" href="../youtube/tamil.php">- Tamil </a>
                                <a class="nav-link" href="../youtube/telugu.php">- Telugu </a>
                                <a class="nav-link" href="../youtube/tourism.php">- Tourism </a>
                            </div>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="../eortok.html">
                                <i class="bi bi-camera-video"></i>Eortok
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="../resume.html">
                                <i class="bi bi-folder"></i>Resumes
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="../live.html">
                                <i class="bi bi-chat"></i> Go Live
                            </a>
                        </li>
                        <li class="nav-item" style="cursor:pointer">
                            <a class="nav-link" onclick="userLogout()">
                                <i class="bi bi-box-arrow-left"></i> Logout
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>
        <!-- Main content -->
        <div class="h-screen flex-grow-1 overflow-y-lg-auto">
            <!-- Header -->
            <header class="bg-surface-primary border-bottom pt-6">
                <div class="container-fluid">
                    <div class="mb-npx">
                        <div class="row align-items-center">
                            <div class="col-sm-6 col-12 mb-4 mb-sm-0">
                                <h1 class="h2 mb-0 ls-tight">Youtube Content - Black & White</h1>
                            </div>
                            <div class="col-sm-6 col-12 text-sm-end"></div>
                        </div>
                        <br>
                    </div>
                </div>
            </header>
            <!-- TAB 1 -->

            <main class="py-6 bg-surface-secondary" id="tabb1">

                <div class="container-fluid">
                    <div class="card shadow border-0 mb-7">
                        <div class="card-header">
                            <h3 class="mb-0" style="text-align: center;" id="tdate">Youtube Content - Black & White</h3>
                        </div>
                        <div class="table-responsive">
                            <table id="dynamoTable" class="table table-hover table-nowrap">
                                <thead class="thead-light">
                                    <tr>
                                        <th scope="col"> Image </th>
                                        <th scope="col"> Name</th>
                                        <th scope="col"> Link</th>
                                        <th scope="col"> Delete</th>
                                    </tr>
                                </thead>
                                <tbody id="tableBody">
                                    <?php foreach ($bhojpuriArray as $index => $movie): ?>
                                        <tr>
                                            <td><img src="<?= $movie['image'] ?>" width="100"></td>
                                            <td>
                                                <?= $movie['name'] ?>
                                            </td>
                                            <td>
                                                <?= $movie['link'] ?>
                                            </td>
                                            <td><a href="?delete_index=<?= $index ?>"
                                                    onclick="return confirm('Are you sure you want to delete this movie?')">Delete</a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <div class="modal fade" id="myModal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"> </h4>
                    <button type="button" style="display: none;" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <select id="mySelect" style="border:1px solid black"></select>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://sdk.amazonaws.com/js/aws-sdk-2.101.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.0/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
    <script src="https://raw.githack.com/eKoopmans/html2pdf/master/dist/html2pdf.bundle.js"></script>
    <script src="../js/navbar.js"></script>
    <script src="../js/pdfcsv.js"></script>

</body>

</html>