document.getElementById('checkButton').addEventListener('click', checksub);

AWS.config.update({
    accessKeyId: 'AKIA3XSV5XR6YHPGE4DR',
    secretAccessKey: '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',
    region: 'ap-south-1'
});

const dynamoDB = new AWS.DynamoDB.DocumentClient();
const tableName = 'eortv';
async function scanDynamoDB(zemailid, exclusiveStartKey = null) {
    const params = {
        TableName: tableName,
        ProjectionExpression: 'useremail, usernumber, eortv_media, signMethod', // Add 'signMethod' to the ProjectionExpression
        FilterExpression: 'useremail = :emailid OR usernumber = :number',
        ExpressionAttributeValues: {
            ':emailid': zemailid,
            ':number': zemailid,
        },
    };
    if (exclusiveStartKey) {
        params.ExclusiveStartKey = exclusiveStartKey;
    }
    try {
        const data = await dynamoDB.scan(params).promise();
        const items = data.Items;
        if (data.LastEvaluatedKey) {
            const moreItems = await scanDynamoDB(zemailid, data.LastEvaluatedKey);
            items.push(...moreItems);
        }
        return items;
    } catch (err) {
        console.error('Error scanning DynamoDB:', err);
        throw err;
    }
}

async function getSubscriptionDetails(details) {
    const params = {
        TableName: 'SubscribedUsers',
        Key: {
            subscribers: details,
        },
    };
    try {
        const data = await dynamoDB.get(params).promise();
        return data.Item;
    } catch (err) {
        console.error('Error retrieving subscription details from DynamoDB:', err);
        throw err;
    }
}

async function checksub() {
    const loaderElement = document.getElementById('loader');
    const zemailid = document.getElementById('zemailid').value;

    if (!zemailid || zemailid.trim() === '') {
        alert('Please Add Email ID/Number');
        return;
    }

    loaderElement.style.display = 'block';

    try {
        const results = await scanDynamoDB(zemailid);
        const fetchSubscriptions = results.map((item) => getSubscriptionDetails(item.eortv_media));
        const subscriptionDetails = await Promise.all(fetchSubscriptions);
        const tableBody = document.getElementById('tableBodsy0');
        tableBody.innerHTML = '';

        results.forEach((item, index) => {
            const subscriptionDetail = subscriptionDetails[index] || {};
            const { startdate, enddate, paymentID } = subscriptionDetail;
            const newRow = document.createElement('tr');
            newRow.innerHTML = `
                <td style="border:1px solid black">${item.eortv_media}</td>
                <td style="border:1px solid black">${item.signMethod}</td>
                <td style="border:1px solid black">${item.useremail}</td>
                <td style="border:1px solid black">${item.usernumber}</td>
                <td style="border:1px solid black">${startdate || 'Not Available'}</td>
                <td style="border:1px solid black">${enddate || 'Not Available'}</td>
                <td style="border:1px solid black">${paymentID || 'Not Available'}</td>
            `;
            tableBody.appendChild(newRow);
        });
        loaderElement.style.display = 'none';
    } catch (err) {
        loaderElement.style.display = 'none';
        console.error('Error:', err);
    }
}

const activateButton = document.getElementById('activatebtn');
const modal = document.getElementById('subscriptionModal');
const closeModal = document.getElementById('closeModal');
const submitSubscription = document.getElementById('submitSubscription');

function openModal() {
    modal.style.display = 'block';
}

function closeModalFn() {
    modal.style.display = 'none';
}

function submitSubscriptionDetails() {
    const uid = document.getElementById('quid').value;
    const paymentId = document.getElementById('qpay').value;
    const name = document.getElementById('qname').value;
    const phoneNumber = document.getElementById('qphnum').value;
    const emailId = document.getElementById('qmail').value;
    const currency = document.getElementById('qcurrency').value;
    const subscriptionType = document.getElementById('qtype').value;
    const amountpaid = document.getElementById('qpaid').value;

    if (!uid || !paymentId || !name || !phoneNumber || !emailId || !currency || !amountpaid || !subscriptionType) {
        alert('Please fill in all the fields before submitting.');
        return;
    }

    let currencyValue;
    if (currency === 'Indian') {
        currencyValue = 'INR';
    } else if (currency === 'International') {
        currencyValue = 'USD';
    } else {
        alert('Invalid currency value.');
        return;
    }

    const today = new Date();
    let enddate;
    if (subscriptionType === '1 Month') {
        enddate = addDays(today, 30);
    } else if (subscriptionType === '1 Week' || subscriptionType === '1 Weekly') {
        enddate = addDays(today, 7);
    } else if (subscriptionType === '2 Month') {
        enddate = addDays(today, 60);
    } else if (subscriptionType === '3 Month') {
        enddate = addDays(today, 90);
    } else if (subscriptionType === '6 Month') {
        enddate = addDays(today, 180);
    } else if (subscriptionType === '12 Month') {
        enddate = addDays(today, 365);
    } else {
        alert('Invalid subscription type.');
        return;
    }


    // Create an object to represent the item to be updated in DynamoDB
    const itemToUpdate = {
        subscribers: uid,
        email: emailId,
        paymentID: paymentId,
        name: name,
        number: phoneNumber,
        amount: amountpaid,
        location: 'Mumbai, Maharashtra, India',
        paidthrough: 'android',
        startdate: getFormattedDate(today),
        enddate: getFormattedDate(enddate),
        currency: currencyValue,
        type: subscriptionType
    };

    const params = {
        TableName: 'SubscribedUsers',
        Key: { subscribers: uid },
        UpdateExpression: 'SET #email = :email, #amount = :amount, #paymentID = :paymentID, #name = :name, #number = :number, #location = :location, #paidthrough = :paidthrough, #startdate = :startdate, #enddate = :enddate, #currency = :currency, #type = :type',
        ExpressionAttributeNames: {
            '#email': 'email',
            '#paymentID': 'paymentID',
            '#amount': 'amount',
            '#name': 'name',
            '#number': 'number',
            '#location': 'location',
            '#paidthrough': 'paidthrough',
            '#startdate': 'startdate',
            '#enddate': 'enddate',
            '#currency': 'currency',
            '#type': 'type'
        },
        ExpressionAttributeValues: {
            ':email': emailId,
            ':amount': amountpaid,
            ':paymentID': paymentId,
            ':name': name,
            ':number': phoneNumber,
            ':location': 'Mumbai, Maharashtra, India',
            ':paidthrough': 'android',
            ':startdate': itemToUpdate.startdate,
            ':enddate': itemToUpdate.enddate,
            ':currency': currencyValue,
            ':type': subscriptionType
        }
    };

    dynamoDB.update(params, (err, data) => {
        if (err) {
            console.error('Error updating item:', err);
            alert("Error In Subscription");

        } else {
            console.log('Item updated successfully:', data);
            alert("Added Subscription");
            closeModalFn();
        }
    });
}

function getFormattedDate(date) {
    const day = date.getDate().toString().padStart(2, '0');
    const month = (date.getMonth() + 1).toString().padStart(2, '0');
    const year = date.getFullYear();
    return `${day}-${month}-${year}`;
}

function addDays(date, days) {
    const result = new Date(date);
    result.setDate(result.getDate() + days);
    return result;
}


activateButton.addEventListener('click', openModal);
closeModal.addEventListener('click', closeModalFn);
submitSubscription.addEventListener('click', submitSubscriptionDetails);

window.addEventListener('click', (event) => {
    const modal = document.getElementById('subscriptionModal');
    if (event.target === modal) {
        closeModalFn();
    }
});
